/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.bedrock;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.util.FormImage;
import org.kingdoms.gui.bedrock.FormType;
import org.kingdoms.gui.bedrock.components.FormComponentObject;
import org.kingdoms.gui.bedrock.components.FormComponentParser;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.nonnull.Nullability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0019\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/gui/bedrock/FormBuilderObject;", "", "type", "Lorg/kingdoms/gui/bedrock/FormType;", "title", "Lorg/kingdoms/locale/compiler/MessageObject;", "options", "", "", "Lorg/kingdoms/gui/bedrock/components/FormComponentObject;", "iconImageType", "Lorg/geysermc/cumulus/util/FormImage$Type;", "icon", "<init>", "(Lorg/kingdoms/gui/bedrock/FormType;Lorg/kingdoms/locale/compiler/MessageObject;Ljava/util/Map;Lorg/geysermc/cumulus/util/FormImage$Type;Ljava/lang/String;)V", "getType", "()Lorg/kingdoms/gui/bedrock/FormType;", "getTitle", "()Lorg/kingdoms/locale/compiler/MessageObject;", "getOptions", "()Ljava/util/Map;", "getIconImageType", "()Lorg/geysermc/cumulus/util/FormImage$Type;", "getIcon", "()Ljava/lang/String;", "build", "Lorg/geysermc/cumulus/form/util/FormBuilder;", "settings", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "Companion", "core"})
public final class FormBuilderObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FormType type;
    @NotNull
    private final MessageObject title;
    @NotNull
    private final Map<String, FormComponentObject> options;
    @Nullable
    private final FormImage.Type iconImageType;
    @Nullable
    private final String icon;

    public FormBuilderObject(@NotNull FormType type, @NotNull MessageObject title, @NotNull Map<String, ? extends FormComponentObject> options, @Nullable FormImage.Type iconImageType, @Nullable String icon) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.type = type;
        this.title = title;
        this.options = options;
        this.iconImageType = iconImageType;
        this.icon = icon;
    }

    @NotNull
    public final FormType getType() {
        return this.type;
    }

    @NotNull
    public final MessageObject getTitle() {
        return this.title;
    }

    @NotNull
    public final Map<String, FormComponentObject> getOptions() {
        return this.options;
    }

    @Nullable
    public final FormImage.Type getIconImageType() {
        return this.iconImageType;
    }

    @Nullable
    public final String getIcon() {
        return this.icon;
    }

    @NotNull
    public final FormBuilder<?, ?, ?> build(@NotNull MessagePlaceholderProvider settings) {
        FormBuilder formBuilder;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                ModalForm.Builder builder = ModalForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
                formBuilder = (FormBuilder)builder;
                break;
            }
            case 2: {
                SimpleForm.Builder builder = SimpleForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
                formBuilder = (FormBuilder)builder;
                break;
            }
            case 3: {
                CustomForm.Builder builder = CustomForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
                formBuilder = (FormBuilder)builder;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FormBuilder form = formBuilder;
        KLogger.debug((DebugNS)KingdomsDebug.GUIS_PREPARE, "building form of type " + form);
        form.title(this.title.buildPlain(settings));
        if (form instanceof CustomForm.Builder && this.iconImageType != null && this.icon != null) {
            ((CustomForm.Builder)form).icon(FormImage.of((FormImage.Type)this.iconImageType, (String)this.icon));
        }
        boolean first = true;
        for (Map.Entry<String, FormComponentObject> entry : this.options.entrySet()) {
            String name = entry.getKey();
            FormComponentObject option = entry.getValue();
            KLogger.debug((DebugNS)KingdomsDebug.GUIS_PREPARE, "building option " + name + " -> " + option + " for " + form);
            FormBuilder formBuilder2 = form;
            if (formBuilder2 instanceof SimpleForm.Builder) {
                option.build((SimpleForm.Builder)form, settings);
            } else if (formBuilder2 instanceof ModalForm.Builder) {
                option.build((ModalForm.Builder)form, settings, first);
            } else if (formBuilder2 instanceof CustomForm.Builder) {
                option.build((CustomForm.Builder)form, settings);
            }
            first = false;
        }
        return form;
    }

    @JvmStatic
    @NotNull
    public static final FormBuilderObject parse(@NotNull ConfigSection config) {
        return Companion.parse(config);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/gui/bedrock/FormBuilderObject$Companion;", "", "<init>", "()V", "parse", "Lorg/kingdoms/gui/bedrock/FormBuilderObject;", "config", "Lorg/kingdoms/utils/config/ConfigSection;", "detectImageType", "Lorg/geysermc/cumulus/util/FormImage$Type;", "str", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FormBuilderObject parse(@NotNull ConfigSection config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            String[] stringArray = new String[]{"forms"};
            ConfigSection section = Nullability.assertNotNull(config.getSection(stringArray), "No forms option specified for");
            MessageObject title = MessageCompiler.compile(Nullability.assertNotNull(section.getString("title"), "No title specified for form"));
            String string = Nullability.assertNotNull(section.getString("type"), "Cannot find 'form-type' option");
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            FormType formType = FormType.valueOf(string2);
            Map options = new HashMap();
            String[] stringArray2 = new String[]{"options"};
            Map<String, ConfigSection> map = section.getSection(stringArray2).getSections();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getSections(...)");
            for (Map.Entry<String, ConfigSection> entry : map.entrySet()) {
                String key = entry.getKey();
                ConfigSection option = entry.getValue();
                Intrinsics.checkNotNull((Object)option);
                options.put(key, FormComponentParser.Companion.parse(option));
            }
            String icon = section.getString("icon");
            FormImage.Type imageType = this.detectImageType(icon);
            Intrinsics.checkNotNull((Object)title);
            return new FormBuilderObject(formType, title, options, imageType, icon);
        }

        @Nullable
        public final FormImage.Type detectImageType(@Nullable String str) {
            if (str == null) {
                return null;
            }
            if (StringsKt.startsWith$default((String)str, (String)"http:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"https:", (boolean)false, (int)2, null)) {
                return FormImage.Type.URL;
            }
            return FormImage.Type.PATH;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormType.values().length];
            try {
                nArray[FormType.MODAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormType.SIMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormType.CUSTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

