/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.objects.ConditionalGUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

public final class ReusableOptionHandler
extends OptionHandler {
    private final GUIOptionBuilder optionBuilder;
    private final GUIOptionObject mainOption;
    private AtomicInteger slotIteratorCursor = new AtomicInteger();
    private int[] slots;

    public void referenceSlot(ReusableOptionHandler other) {
        this.slotIteratorCursor = other.slotIteratorCursor;
        this.slots = other.slots;
    }

    public ReusableOptionHandler(InteractiveGUI gui, GUIOptionBuilder option) {
        super(gui, ReusableOptionHandler.getMainOf(option).getName());
        this.optionBuilder = option;
        this.mainOption = ReusableOptionHandler.getMainOf(option);
        this.slots = this.mainOption.getSlots();
    }

    static GUIOptionObject getMainOf(GUIOptionBuilder settings) {
        return settings instanceof ConditionalGUIOptionObject ? ((ConditionalGUIOptionObject)settings).getMainObject() : (GUIOptionObject)settings;
    }

    @Override
    public ReusableOptionHandler setSettings(MessagePlaceholderProvider settings) {
        super.setSettings(settings);
        return this;
    }

    public int slotsCount() {
        return this.mainOption.getSlots().length;
    }

    public boolean hasNext() {
        return this.slotIteratorCursor.get() != this.slots.length;
    }

    private int next() {
        if (this.slotIteratorCursor.get() == this.slots.length) {
            throw new NoSuchElementException("No more slots left: " + this.slotsCount());
        }
        return this.mainOption.getSlots()[this.slotIteratorCursor.getAndIncrement()];
    }

    @Override
    public void done() {
        this.settings.inheritPlaceholders(this.gui.getMessageContext()).inheritContext(this.gui.getMessageContext(), false);
        GUIOption option = this.object = new GUIOption(this.holder, this.optionBuilder.getOption(this.settings));
        option.defineVariables(this.settings);
        ItemStack item = option.getItem();
        if (this.itemHandler != null) {
            item = (ItemStack)this.itemHandler.apply(item);
        }
        option.setRunnables(this.handlers);
        option.setConversation(this.conversation);
        this.handlers = new QuickEnumMap((Enum[])EnumCache.CLICK_TYPES);
        if (this.gui instanceof InventoryInteractiveGUI) {
            InventoryInteractiveGUI inv = (InventoryInteractiveGUI)this.gui;
            int slot = this.next();
            inv.getInventory().setItem(slot, item);
            inv.getOptions().put(slot, option);
        }
    }

    @Override
    public ReusableOptionHandler editItem(Function<ItemStack, ItemStack> itemHandler) {
        super.editItem(itemHandler);
        return this;
    }

    @Override
    public ReusableOptionHandler setEdits(Object ... edits) {
        this.settings.resetPlaceholders();
        super.setEdits(edits);
        return this;
    }

    @Override
    public OptionHandler setConversation(BiConsumer<OptionHandler, String> conversation) {
        this.conversation = input -> conversation.accept(this, (String)input);
        return this;
    }

    @Override
    public ReusableOptionHandler onNormalClicks(Runnable runnable) {
        super.onNormalClicks(runnable);
        return this;
    }

    @Override
    public ReusableOptionHandler on(ClickType type, Runnable runnable) {
        super.on(type, runnable);
        return this;
    }

    @Override
    public ReusableOptionHandler on(ClickType type, Consumer<OptionHandler> runnable) {
        super.on(type, runnable);
        return this;
    }
}

