/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/gui/InteractableSlotHandler;", "", "event", "Lorg/bukkit/event/inventory/InventoryInteractEvent;", "item", "Lorg/bukkit/inventory/ItemStack;", "slot", "", "safe", "", "<init>", "(Lorg/bukkit/event/inventory/InventoryInteractEvent;Lorg/bukkit/inventory/ItemStack;IZ)V", "getEvent", "()Lorg/bukkit/event/inventory/InventoryInteractEvent;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "getSlot", "()I", "cancelled", "returnItems", "getReturnItems", "()Z", "setReturnItems", "(Z)V", "isCancelled", "setCancelled", "", "unsafeOperation", "runnable", "Ljava/lang/Runnable;", "core"})
public final class InteractableSlotHandler {
    @NotNull
    private final InventoryInteractEvent event;
    @NotNull
    private final ItemStack item;
    private final int slot;
    private final boolean safe;
    private boolean cancelled;
    private boolean returnItems;

    public InteractableSlotHandler(@NotNull InventoryInteractEvent event, @NotNull ItemStack item, int slot, boolean safe) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.event = event;
        this.item = item;
        this.slot = slot;
        this.safe = safe;
    }

    @NotNull
    public final InventoryInteractEvent getEvent() {
        return this.event;
    }

    @NotNull
    public final ItemStack getItem() {
        return this.item;
    }

    public final int getSlot() {
        return this.slot;
    }

    public final boolean getReturnItems() {
        return this.returnItems;
    }

    public final void setReturnItems(boolean bl) {
        this.returnItems = bl;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public final void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public final void unsafeOperation(@NotNull Runnable runnable) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (!this.cancelled && !this.safe) {
            BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), runnable, 1L);
            unit = bukkitTask;
            Intrinsics.checkNotNullExpressionValue((Object)bukkitTask, (String)"runTaskLater(...)");
        } else {
            runnable.run();
            unit = Unit.INSTANCE;
        }
    }
}

