/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUILanguageSyncer;
import org.kingdoms.gui.GUIParser;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlFile;
import org.kingdoms.utils.config.adapters.YamlFiledDefaults;
import org.kingdoms.utils.config.adapters.YamlParseContext;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.fs.FolderRegistry;

public final class GUIConfig {
    private static final Map<String, Function<CommandContext, InteractiveGUI>> INDEPENDENT_GUIS = new HashMap<String, Function<CommandContext, InteractiveGUI>>();
    protected static final NodeValidator SCHEMA;
    public static final String FOLDER_NAME = "guis";
    public static final String TEMPLATES_FOLDER_NAME = "templates";
    public static final Path FOLDER;
    private static final Function<String[], Boolean> SYNC_EXCLUSION;

    public static Path getFolder() {
        return FOLDER;
    }

    public static void loadInternalGUIs(Plugin owner) {
        String starter = "/guis";
        URI uri = null;
        try {
            uri = owner.getClass().getResource(starter).toURI();
        }
        catch (Exception ex) {
            MessageHandler.sendConsolePluginMessage("&cUnable to find plugin GUI with URI&8: &e" + starter);
            MessageHandler.sendConsolePluginMessage("&cUsing the default GUI config...");
            ex.printStackTrace();
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, new HashMap());){
            int len = starter.length() + 1;
            Files.walk(zipfs.getPath(starter, new String[0]), new FileVisitOption[0]).forEach(gui -> {
                String name = gui.toString();
                if (!name.startsWith("/guis/templates") && name.endsWith(".yml")) {
                    name = name.substring(len, name.length() - ".yml".length());
                    GUIConfig.registerGUI(owner, name, false, false);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadFolderGUIs() {
        FolderRegistry registry = new FolderRegistry("GUI Registry", SupportedLanguage.EN.getGUIFolder()){

            @Override
            protected Pair<String, URI> getDefaultsURI() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void handle(@NonNull FolderRegistry.Entry entry) {
                String name = entry.getName();
                if (name.startsWith(GUIConfig.TEMPLATES_FOLDER_NAME)) {
                    return;
                }
                GUIConfig.registerGUI((Plugin)Kingdoms.get(), name, false, true);
            }

            @Override
            public void register() {
                this.visitPresent();
            }
        };
        registry.copyDefaults(false).useDefaults(false);
        registry.register();
    }

    public static void init() {
        GUIConfig.loadInternalGUIs((Plugin)Kingdoms.get());
        GUIConfig.loadFolderGUIs();
        for (SupportedLanguage otherLangs : SupportedLanguage.getInstalled()) {
            if (otherLangs == Language.getDefault()) continue;
            GUIConfig.registerGUIsFor(otherLangs);
        }
        GUIConfig.standardGUISync();
    }

    public static void standardGUISync() {
        if (!KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_AUTOMATIC.getBoolean()) {
            return;
        }
        String refLangName = KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_REFERENCE_LANGUAGE.getString();
        if (refLangName == null || refLangName.isEmpty()) {
            return;
        }
        SupportedLanguage refLang = SupportedLanguage.fromName(refLangName);
        if (refLang == null) {
            KLogger.error("Unknown reference language specified for GUI synchronization: " + refLangName);
            return;
        }
        if (!refLang.isInstalled()) {
            KLogger.error("The specified reference language for GUI synchronization is not installed: " + refLang);
            return;
        }
        KLogger.info("Synchronizing GUIs against " + refLang + "...");
        int synced = GUIConfig.synchronizeAllGUIs(refLang);
        KLogger.info("Synchronized a total of " + synced + " GUIs.");
    }

    public static void registerIndependentGUI(KingdomsGUI gui, Function<CommandContext, InteractiveGUI> fn) {
        String name = gui.getGUIPath();
        if (INDEPENDENT_GUIS.containsKey(name)) {
            throw new IllegalArgumentException("Independent GUI already registered: " + name);
        }
        INDEPENDENT_GUIS.put(name, fn);
    }

    public static Map<String, Function<CommandContext, InteractiveGUI>> getIndependentGuis() {
        return INDEPENDENT_GUIS;
    }

    public static GUIObject getGUI(String name, Language locale, boolean optional) {
        GUIObject guiTemplate = locale.getGUIOrDefault(name, optional);
        if (!optional) {
            if (guiTemplate == null) {
                throw new IllegalArgumentException("Unknown GUI: " + name + " (for locale " + locale + ')');
            }
            if (guiTemplate.getConfig().getFile() != null && !guiTemplate.getConfig().getFile().exists()) {
                KLogger.warn("The GUI file for '" + name + "' was deleted, regenerating a new one...");
                guiTemplate.getConfig().saveDefaultConfig();
                GUIConfig.reload(guiTemplate, locale);
            }
        }
        return guiTemplate;
    }

    public static void reload(String name, Language locale) {
        GUIObject gui = locale.getGUIOrDefault(name, false);
        Objects.requireNonNull(gui, () -> "Cannot reload unknown GUI: " + name);
        GUIConfig.reload(gui, locale);
    }

    public static void reload(GUIObject gui, Language lang) {
        GUIConfig.reload(gui, lang, true);
    }

    public static void reload(GUIObject gui, Language lang, boolean sync) {
        Objects.requireNonNull(gui, () -> "Cannot reload null GUI for locale: " + lang);
        Objects.requireNonNull(lang, () -> "Cannot reload GUI for null locale: " + gui.getName());
        gui.getConfig().reload();
        GUIConfig.loadAndRegisterGUI(lang, gui.getConfig(), gui.getName());
        if (sync) {
            GUIConfig.synchronizeGUIs(gui, lang);
        }
    }

    public static int synchronizeAllGUIs(SupportedLanguage refLang) {
        int synced = 0;
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            if (lang == refLang || !lang.isInstalled()) continue;
            for (GUIObject gui : lang.getGUIs().values()) {
                GUIObject refGUI = refLang.getGUIs().get(gui.getName());
                if (refGUI == null || !GUIConfig.synchronizeGUI(lang, gui, refGUI)) continue;
                ++synced;
            }
        }
        return synced;
    }

    public static void synchronizeGUIs(GUIObject refGUI, Language except) {
        if (!KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_AUTOMATIC.getBoolean()) {
            return;
        }
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            GUIObject langGUI;
            if (!lang.isInstalled() || lang == except || (langGUI = lang.getGUIs().get(refGUI.getName())) == null) continue;
            GUIConfig.synchronizeGUI(lang, langGUI, refGUI);
        }
    }

    public static boolean synchronizeGUI(SupportedLanguage lang, GUIObject gui, GUIObject refGUI) {
        YamlFile toSync = new YamlFile(gui.getConfig().getFile()).setResolveAliases(false).setImportDeclarations(false).load();
        YamlFile reference = new YamlFile(refGUI.getConfig().getFile()).setResolveAliases(false).setImportDeclarations(false).load();
        GUILanguageSyncer sync = new GUILanguageSyncer(gui.getName(), toSync.getConfig(), reference.getConfig(), SYNC_EXCLUSION);
        sync.update();
        if (sync.hasChanged()) {
            toSync.saveConfig();
            GUIConfig.reload(gui, lang, false);
        }
        return sync.hasChanged();
    }

    private static void handleAadapter(YamlWithDefaults yaml, Language lang) {
        yaml.setResolveAliases(false).load();
        yaml.setSchema(SCHEMA);
        yaml.setImporter(lang.getYamlImporter()).importDeclarations();
    }

    private static void registerGUI(Plugin owner, String name, boolean optional, boolean skipIfLoaded) {
        Language lang = Language.getDefault();
        if (skipIfLoaded && lang.getGUIs().containsKey(name)) {
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, "Loading GUI&8: &9" + name);
        String path = "guis/" + lang.getLowerCaseName() + '/' + name + ".yml";
        String resourcePath = "guis/" + name + ".yml";
        File localFile = new File(Kingdoms.get().getDataFolder(), path);
        if (!optional && !localFile.exists() && owner.getClass().getResource('/' + resourcePath) == null) {
            KLogger.error("Could not find default " + lang + " GUI translation for " + name + " GUI.");
            return;
        }
        YamlResource adapter = new YamlResource(owner, localFile, resourcePath);
        GUIConfig.handleAadapter(adapter, lang);
        GUIConfig.loadAndRegisterGUI(lang, adapter, name);
    }

    public static void loadAndRegisterGUI(Language lang, YamlWithDefaults adapter, String name) {
        if (!adapter.isLoaded()) {
            KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, () -> "Removed " + lang.getLowerCaseName() + '/' + name + " GUI since its config was not loaded.");
            lang.getGUIs().remove(name);
            return;
        }
        ConfigManager.warnAboutValidation(adapter.getFile().toString(), adapter.validate());
        GUIObject gui = GUIParser.parse(adapter, name, lang);
        if (gui != null) {
            lang.getGUIs().put(name, gui);
        } else {
            lang.getGUIs().remove(name);
            KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, () -> "Did not load " + lang.getLowerCaseName() + '/' + name + " GUI because it was null");
        }
    }

    public static void registerGUIsFor(SupportedLanguage lang) {
        lang.ensureInstalled();
        Path guisRepoFolder = lang.getRepoPath().resolve(FOLDER_NAME);
        for (String gui : SupportedLanguage.getRegisteredGUINames()) {
            Path guiRepoPath = guisRepoFolder.resolve(gui + ".yml");
            File localFile = lang.getGUIFolder().resolve(gui + ".yml").toFile();
            if (!Files.exists(guiRepoPath, new LinkOption[0]) && !localFile.exists()) continue;
            YamlWithDefaults adapter = GUIConfig.createAdapter(localFile, guiRepoPath.toFile(), lang);
            GUIConfig.loadAndRegisterGUI(lang, adapter, gui);
        }
    }

    public static YamlWithDefaults createAdapter(File localFile, File repoFile, SupportedLanguage lang) {
        YamlFiledDefaults adapter = new YamlFiledDefaults(localFile, repoFile);
        GUIConfig.handleAadapter(adapter, lang);
        return adapter;
    }

    public static void reloadAll() {
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            if (!lang.isInstalled()) continue;
            for (GUIObject gui : lang.getGUIs().values()) {
                GUIConfig.reload(gui, (Language)lang);
            }
        }
        GUIConfig.standardGUISync();
    }

    static {
        FOLDER = Kingdoms.getPath(FOLDER_NAME);
        String schemaPath = "schemas/guis/schema.yml";
        InputStream is = Kingdoms.get().getResource(schemaPath);
        MappingNode schemaYml = YamlContainer.parse(new YamlParseContext().named("GUI Schema").stream(is));
        SCHEMA = Validator.parseSchema(schemaYml);
        SYNC_EXCLUSION = currPath -> {
            String first = currPath[0];
            if (first.equals("title")) {
                return true;
            }
            if (first.equals("options")) {
                String last = currPath[((String[])currPath).length - 1];
                return last.equals("name") || last.equals("lore");
            }
            return false;
        };
    }
}

