/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.items;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.kingdoms.abstraction.KingdomsBlockOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public abstract class KingdomsBlockEvent<I extends KingdomBlock>
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomsBlockOperator {
    private final KingdomPlayer player;
    private final @NonNull I kingdomBlock;
    private final Event event;
    private boolean cancelled;

    public KingdomsBlockEvent(Event event, KingdomPlayer player, I kingdomItem) {
        this.event = event;
        this.player = player;
        this.kingdomBlock = (KingdomBlock)Objects.requireNonNull(kingdomItem, "Kingdom item cannot be null");
    }

    @Override
    public KingdomPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        super.addMessageContextEdits(context);
        context.withContext(this.player.getOfflinePlayer());
        context.addChild("item", this.kingdomBlock.getMessageContext());
    }

    @Deprecated
    public @NonNull I getKingdomItem() {
        return this.kingdomBlock;
    }

    @Nullable
    public I getKingdomBlock() {
        return this.kingdomBlock;
    }

    @Override
    public Event getCause() {
        return this.event;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
        if (this.event instanceof Cancellable) {
            ((Cancellable)this.event).setCancelled(cancel);
        }
    }
}

