/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.invasion;

import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.kingdoms.abstraction.InvasionOperator;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.managers.invasions.Invasion;

public class KingdomInvadeAttackEvent
extends KingdomsEvent
implements InvasionOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Invasion invasion;
    private final EntityDamageByEntityEvent source;

    public KingdomInvadeAttackEvent(Invasion invasion, EntityDamageByEntityEvent source) {
        Objects.requireNonNull(invasion, "Invasion cannot be null");
        Objects.requireNonNull(source, "Main damage event cannot be null");
        this.invasion = invasion;
        this.source = source;
    }

    public static @NonNull HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isAttackerChampion() {
        return this.source.getEntity() instanceof Player;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Override
    public Invasion getInvasion() {
        return this.invasion;
    }

    public EntityDamageByEntityEvent getSource() {
        return this.source;
    }

    @NotNull
    public Entity getDamager() {
        return this.source.getDamager();
    }

    public double getDamage() {
        return this.source.getDamage();
    }

    public void setDamage(double damage) {
        this.source.setDamage(damage);
    }

    public final double getFinalDamage() {
        return this.source.getFinalDamage();
    }

    public boolean isCancelled() {
        return this.source.isCancelled();
    }

    public void setCancelled(boolean cancel) {
        this.source.setCancelled(cancel);
    }

    public Entity getEntity() {
        return this.source.getEntity();
    }
}

