/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general.ranks;

import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/events/general/ranks/RelativePriorityRankIdentifier;", "Lorg/kingdoms/events/general/ranks/RankIdentifier;", "jump", "", "<init>", "(I)V", "getJump", "()I", "identify", "Lorg/kingdoms/constants/player/Rank;", "group", "Lorg/kingdoms/constants/group/Group;", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerRankChangeContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerRankChangeContext.kt\norg/kingdoms/events/general/ranks/RelativePriorityRankIdentifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class RelativePriorityRankIdentifier
implements RankIdentifier {
    private final int jump;

    public RelativePriorityRankIdentifier(int jump) {
        this.jump = jump;
    }

    public final int getJump() {
        return this.jump;
    }

    @Override
    @NotNull
    public Rank identify(@NotNull Group group, @NotNull KingdomPlayer player) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Rank rank = group instanceof Kingdom ? player.getRank() : player.getNationRank();
        if (rank == null) {
            boolean $i$a$-checkNotNull-RelativePriorityRankIdentifier$identify$currentRank$22 = false;
            String $i$a$-checkNotNull-RelativePriorityRankIdentifier$identify$currentRank$22 = "Current rank is null: " + group + " - " + player;
            throw new IllegalStateException($i$a$-checkNotNull-RelativePriorityRankIdentifier$identify$currentRank$22.toString());
        }
        Rank currentRank = rank;
        int currentPriority = currentRank.getPriority();
        int newPriority = currentPriority + this.jump;
        Rank newRank = group.getRanks().get(newPriority);
        if (newRank == null) {
            throw new IllegalArgumentException("Cannot jump from rank '" + currentRank.toShortString() + "' in group '" + group.getName() + "'  with maximum of " + group.getRanks().size() + " ranks (" + group.getRanks() + ") to rank with priority: " + newPriority + ", jumped: " + this.jump);
        }
        return newRank;
    }
}

