/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;

public class KingdomKingChangeEvent
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Kingdom kingdom;
    private boolean cancelled;
    private KingdomPlayer newKing;
    private final Reason reason;

    public KingdomKingChangeEvent(Kingdom kingdom, KingdomPlayer newKing, Reason reason) {
        this.kingdom = kingdom;
        this.newKing = newKing;
        this.reason = reason;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public Reason getReason() {
        return this.reason;
    }

    public KingdomPlayer getNewKing() {
        return this.newKing;
    }

    public void setNewKing(UUID id) {
        Objects.requireNonNull(id);
        if (!this.kingdom.isMember(id)) {
            throw new IllegalArgumentException("The player with the specified ID " + id + " is not in the kingdom");
        }
        if (this.kingdom.hasOwner() && this.kingdom.getKingId().equals(id)) {
            throw new IllegalArgumentException("The player with the specified ID " + id + " is already the king");
        }
        this.newKing = KingdomPlayer.getKingdomPlayer(id);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return this.newKing;
    }

    @Override
    @Nullable
    public Kingdom getKingdom() {
        return this.kingdom;
    }

    public static enum Reason {
        ADMIN,
        KINGS_DECISION,
        ELECTIONS,
        INACTIVITY,
        OTHER;

    }
}

