/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class KingdomCreateEvent
extends KingdomsEvent
implements KingdomOperator,
PlayerOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Kingdom kingdom;
    private final KingdomPlayer kingdomPlayer;

    public KingdomCreateEvent(Kingdom kingdom, @Nullable KingdomPlayer kingdomPlayer) {
        this.kingdom = kingdom;
        this.kingdomPlayer = kingdomPlayer;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.withContext(this.kingdom.hasOwner() ? this.kingdom.getKing().getPlayer() : null);
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Override
    public Kingdom getKingdom() {
        return this.kingdom;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return this.kingdomPlayer;
    }
}

