/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.dependencies.classpath;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import org.kingdoms.dependencies.classpath.ClassPathAppender;
import org.kingdoms.dependencies.classpath.JarInJarClassLoader;

public class JarInJarClassPathAppender
implements ClassPathAppender {
    private final JarInJarClassLoader classLoader;

    public JarInJarClassPathAppender(ClassLoader classLoader) {
        if (!(classLoader instanceof JarInJarClassLoader)) {
            throw new IllegalArgumentException("Loader is not a JarInJarClassLoader: " + classLoader.getClass().getName());
        }
        this.classLoader = (JarInJarClassLoader)classLoader;
    }

    @Override
    public void addJarToClasspath(Path file) {
        try {
            this.classLoader.addURL(file.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

