/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.dependencies.DependencyDownloadException;

public enum DependencyRepository {
    MAVEN_CENTRAL("https://repo1.maven.org/maven2/");

    private final String url;

    private DependencyRepository(String url) {
        this.url = url;
    }

    public URL getURLFor(Dependency dependency) {
        try {
            return new URL(this.url + dependency.getMavenRepoPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL for dependency: " + (Object)((Object)dependency), e);
        }
    }

    protected URLConnection openConnection(Dependency dependency) throws IOException {
        URL dependencyUrl = this.getURLFor(dependency);
        return dependencyUrl.openConnection();
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] downloadRaw(Dependency dependency) throws DependencyDownloadException {
        byte[] byArray;
        block9: {
            URLConnection connection = this.openConnection(dependency);
            InputStream in = connection.getInputStream();
            try {
                byte[] bytes = DependencyRepository.readBytes(in);
                if (bytes.length == 0) {
                    throw new DependencyDownloadException("Empty stream");
                }
                byArray = bytes;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DependencyDownloadException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static byte[] readBytes(InputStream stream) throws IOException {
        int n;
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int MAX_BUFFER_SIZE = 0x7FFFFFF7;
        do {
            byte[] buf = new byte[8192];
            int nread = 0;
            while ((n = stream.read(buf, nread, buf.length - nread)) > 0) {
                nread += n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        int remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public byte[] download(Dependency dependency) throws DependencyDownloadException {
        byte[] bytes = this.downloadRaw(dependency);
        byte[] hash = Dependency.createDigest().digest(bytes);
        if (!dependency.getUsedVersion().checksumMatches(hash)) {
            throw new DependencyDownloadException("Downloaded file had an invalid hash. Expected: " + Base64.getEncoder().encodeToString(dependency.getUsedVersion().getChecksum()) + ' ' + "Actual: " + Base64.getEncoder().encodeToString(hash));
        }
        return bytes;
    }

    public void download(Dependency dependency, Path file) throws DependencyDownloadException {
        try {
            Files.write(file, this.download(dependency), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DependencyDownloadException(e);
        }
    }
}

