/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.dependencies;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kingdoms.dependencies.DependencyVersion;
import org.kingdoms.dependencies.relocation.SimpleRelocation;

public enum Dependency {
    REPTILE_YAML("com{}github{}cryptomorin", "ReptileYAML", "4.0.0", "", SimpleRelocation.of("snakeyaml", "org{}snakeyaml")),
    GSON("com{}google{}code{}gson", "gson", "2.11.0", "V5KNblpu3rKr03cKj5W6RNzkXzsjt6ncKzCcWBVSp4s=", new SimpleRelocation[0]),
    GUAVA("com{}google{}guava", "guava", "33.4.0-jre", "uRjJin5E2+lOvZ/j5Azdqttak+anjrYAi0LfI3JB5Tg=", new SimpleRelocation[0]),
    FASTUTIL("it{}unimi{}dsi", "fastutil-core", "8.5.15", "N5pz4AeQ/IZTGKzAVQ4ujRCJNHWCld8YvOZxm9ADjG0=", SimpleRelocation.of("google", "com{}google")),
    XSERIES("com{}github{}cryptomorin", "XSeries", "13.0.0", "UHAxtpyYMm2z50ZVK+854rlCXDx6W785fnW19LEhMAc=", SimpleRelocation.of("xseries", "com{}cryptomorin{}xseries")),
    ASM("org.ow2.asm", "asm", "9.7.1", "jK3UOsXrbQneBfrsyji5F6BAu5E5x+3rTMgcdAtxMoE=", new SimpleRelocation[0]),
    ASM_COMMONS("org.ow2.asm", "asm-commons", "9.7.1", "mlebVNKSrZvhcdQxP9RznGNVksK1rDpFm70QSc3exqA=", new SimpleRelocation[0]),
    CAFFEINE("com{}github{}ben-manes{}caffeine", "caffeine", Arrays.asList(DependencyVersion.of("2.9.2", "/wJFhkxtOMISmYG18O/IFGBX/kpVSXwjRa7e1GolE7k="), DependencyVersion.of("3.2.0", "7EEd/fDAPyUhhkjOiYYWMLcWgOWFippyeOusjlXKs9c=")), SimpleRelocation.of("caffeine", "com{}github{}benmanes{}caffeine")),
    MARIADB_DRIVER("org{}mariadb{}jdbc", "mariadb-java-client", "3.5.1", "UKUMSjwTww371AWH962aSWGX0oXt4JSGQdnu5o/fIQY=", SimpleRelocation.of("mariadb", "org{}mariadb{}jdbc")),
    MYSQL_DRIVER("com{}mysql", "mysql-connector-j", "9.2.0", "fplBu9zKJE2Hjqlb//eI/Zumplr3V/JL5sYykw1hx+0=", SimpleRelocation.of("mysql", "com{}mysql")),
    POSTGRESQL_DRIVER("org{}postgresql", "postgresql", "42.7.5", "aQILO9IJhFQ+gXOT8ubAGokO8uN6d90R1thQgYHQeas=", SimpleRelocation.of("postgresql", "org{}postgresql")),
    H2_DRIVER("com.h2database", "h2", Arrays.asList(DependencyVersion.of("2.1.214", "1iPNwPYdIYz1SajQnxw5H/kQlhFrIuJHVHX85PvnK9A="), DependencyVersion.of("2.2.224", "udjxk1itqCpPbrWxdMbP4yCjdbWpy1pP5FbWI+blVJc="), DependencyVersion.of("2.3.232", "ja5i0i24mCw9yzgm7bnHJ8XTAgY6Z+731j2C3kAfB9M=")), new SimpleRelocation[0]),
    SLF4J_SIMPLE("org.slf4j", "slf4j-simple", "2.1.0-alpha1", "AU/trHoyKI7W+PcqEAfn+zKuxb/tsnFGfkluCVNIL3U=", new SimpleRelocation[0]),
    SQLITE_DRIVER("org.xerial", "sqlite-jdbc", "3.48.0.0", "2+JKsTjpZUyRj1YSmeR8tqO68alG7al4cfbzq9Tso5U=", new SimpleRelocation[0]),
    MONGODB_DRIVER_CORE("org{}mongodb", "mongodb-driver-core", "5.3.1", "eEz3T5G4JgEASVfFQ3pccJCaa4lLjFqLKXLyBP/VWo0=", SimpleRelocation.of("mongodb", "com{}mongodb"), SimpleRelocation.of("bson", "org{}bson")),
    MONGODB_DRIVER_SYNC("org{}mongodb", "mongodb-driver-sync", "5.3.1", "3MIAcoBFVSzgezgwYjgK06ZySwr/OYja9JYy/r6oJeA=", SimpleRelocation.of("mongodb", "com{}mongodb"), SimpleRelocation.of("bson", "org{}bson")),
    MONGODB_DRIVER_BSON("org{}mongodb", "bson", "5.3.1", "i1zjB/3Fm5uayChJXWRuaYKoG8hLfAyglM/w0TvKjzU=", SimpleRelocation.of("mongodb", "com{}mongodb"), SimpleRelocation.of("bson", "org{}bson")),
    KOTLIN_STDLIB("org{}jetbrains{}" + HashedNames.access$000(), HashedNames.access$000() + "-stdlib", "2.1.0", "1vkbew8wbMopn+x0+3w05IdNb17FuSWgtN4hkB4RnD8=", SimpleRelocation.of(HashedNames.access$000(), HashedNames.access$000())),
    KOTLIN_REFLECT("org{}jetbrains{}" + HashedNames.access$000(), HashedNames.access$000() + "-reflect", "2.1.20-Beta1", "uxRpuV3zOgvxhwXn8MTmrwZJNc5d6JqIbFiVScE2E6U=", SimpleRelocation.of(HashedNames.access$000(), HashedNames.access$000() + "{}reflect")),
    HIKARI("com{}zaxxer", "HikariCP", Arrays.asList(DependencyVersion.of("4.0.3", "fAJK7/HBBjV210RTUT+d5kR9jmJNF/jifzCi6XaIxsk="), DependencyVersion.of("6.2.1", "xlmgg3J86VkCdzV7jD9j+65nIHuwS+q8lkyPTxUwfbw=")), SimpleRelocation.of("hikari", "com{}zaxxer{}hikari"));

    private final List<SimpleRelocation> relocations;
    private static final String MAVEN_FORMAT = "%s/%s/%s/%s-%s.jar";
    private final String groupId;
    private final String artifactId;
    private final Map<String, DependencyVersion> versions;
    private String usedVersion;

    private Dependency(String groupId, String artifactId, String version, String checksum, SimpleRelocation ... relocations) {
        this(groupId, artifactId, Collections.singletonList(DependencyVersion.of(version, checksum)), relocations);
    }

    private Dependency(String groupId, String artifactId, List<DependencyVersion> versions, SimpleRelocation ... relocations) {
        this.groupId = Dependency.rewriteEscaping(groupId);
        this.artifactId = Dependency.rewriteEscaping(artifactId);
        this.relocations = Arrays.asList(relocations);
        this.versions = versions.stream().collect(Collectors.toMap(DependencyVersion::getVersion, ver -> ver));
        this.usedVersion = versions.iterator().next().getVersion();
    }

    private static String rewriteEscaping(String s) {
        return s.replace("{}", ".");
    }

    public void setUsedVersion(String usedVersion) {
        this.usedVersion = usedVersion;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getFileName(String classifier) {
        String name = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        String extra = classifier == null || classifier.isEmpty() ? "" : '-' + classifier;
        return name + '-' + this.getUsedVersion().getVersion() + extra + ".jar";
    }

    String getMavenRepoPath() {
        String version = this.getUsedVersion().getVersion();
        return String.format(MAVEN_FORMAT, this.groupId.replace(".", "/"), this.artifactId, version, this.artifactId, version);
    }

    public DependencyVersion getUsedVersion() {
        return Objects.requireNonNull(this.versions.get(this.usedVersion), () -> "Cannot find default version " + this.usedVersion + " for " + (Object)((Object)this));
    }

    public List<SimpleRelocation> getRelocations() {
        return this.relocations;
    }

    public static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class HashedNames {
        private static final String KOTLIN = new String(Base64.getDecoder().decode("a290bGlu"));

        private HashedNames() {
        }

        static /* synthetic */ String access$000() {
            return KOTLIN;
        }
    }
}

