/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers.base;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.caffeine.cache.CacheLoader;
import org.kingdoms.libs.caffeine.cache.Caffeine;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.cache.JavaMapWrapper;
import org.kingdoms.utils.cache.PeekableMap;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.cache.caffeine.CaffeineWrapper;

public abstract class KeyedDataManager<K, T extends KeyedKingdomsObject<K>>
extends DataManager<T> {
    private final PeekableMap<K, T> cache;
    private final Cache<K, Boolean> doesntExist;
    private final KeyedKingdomsDatabase<K, T> database;
    private final boolean timedCache;

    public KeyedDataManager(Namespace namespace, final KeyedKingdomsDatabase<K, T> database, boolean cacheExistence, KingdomsDataCenter dataCenter) {
        super(namespace, dataCenter);
        Object loader;
        this.database = database;
        this.doesntExist = cacheExistence ? CacheHandler.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build() : null;
        Object object = loader = cacheExistence ? new CacheLoader<K, T>(){

            public @Nullable T load(@NonNull K key) {
                if (KeyedDataManager.this.doesntExist.getIfPresent(key) != null) {
                    return null;
                }
                Object data = database.load(key);
                if (data == null) {
                    KeyedDataManager.this.doesntExist.put(key, (Object)true);
                }
                if (data != null) {
                    data = (KeyedKingdomsObject)KeyedDataManager.this.onLoad(data);
                }
                return data;
            }
        } : new CacheLoader<K, T>(){

            public @Nullable T load(@NonNull K key) {
                Object data = database.load(key);
                if (data != null) {
                    data = (KeyedKingdomsObject)KeyedDataManager.this.onLoad(data);
                }
                return data;
            }
        };
        if (this.isCacheStatic()) {
            this.cache = new JavaMapWrapper<K, T>(new ConcurrentHashMap(), loader);
            this.timedCache = false;
        } else {
            Caffeine<Object, Object> builder = CacheHandler.newBuilder();
            Duration expiration = this.getAutoSaveInterval();
            expiration = expiration == null || expiration.toMinutes() < 30L ? Duration.ofMinutes(30L) : expiration.plusMinutes(10L);
            builder.expireAfterAccess(expiration.toMillis(), TimeUnit.MILLISECONDS);
            builder.weakValues();
            this.cache = new CaffeineWrapper<K, T>(builder.build((CacheLoader)loader));
            this.timedCache = true;
        }
    }

    public void delete(@NonNull T data) {
        this.unload(data);
        Object key = data.getKey();
        this.database.delete(key);
        if (this.doesntExist != null) {
            this.doesntExist.put(key, (Object)true);
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        if (this.doesntExist != null) {
            this.doesntExist.invalidateAll();
        }
    }

    public KeyedKingdomsDatabase<K, T> getDatabase() {
        return this.database;
    }

    @Override
    public void deleteAllData() {
        this.cache.clear();
        this.database.deleteAllData();
    }

    @Override
    public void copyAllDataTo(DataManager<T> dataManager) {
        if (!(dataManager instanceof KeyedDataManager)) {
            throw new UnsupportedOperationException("Cannot copy from " + this + " to " + dataManager);
        }
        ((KeyedDataManager)dataManager).cache.putAll(this.cache);
    }

    @Override
    @ApiStatus.Internal
    public Collection<T> loadAllData(boolean checkIfLoaded) {
        Collection<T> datas = checkIfLoaded ? this.database.loadAllData(x -> !this.cache.containsKey(x)) : this.database.loadAllData(null);
        for (KeyedKingdomsObject data : datas) {
            this.cache(data, false);
        }
        return datas;
    }

    @ApiStatus.Internal
    public List<T> load(Iterable<K> keys, List<T> loaded) {
        HashSet<K> uncachedKeys = new HashSet<K>();
        for (K key : keys) {
            KeyedKingdomsObject data = (KeyedKingdomsObject)this.cache.getIfPresent(key);
            if (data != null) {
                loaded.add(data);
                continue;
            }
            uncachedKeys.add(key);
        }
        this.database.load(uncachedKeys, (T x) -> {
            loaded.add(x);
            this.cache(x, false);
        });
        return loaded;
    }

    @Override
    public int saveAll(boolean smart) {
        if (smart) {
            if (!this.savingState) {
                KLogger.info("Saving state was turned off for " + this + ", skipping saving data...");
                return 0;
            }
            ArrayList<KeyedKingdomsObject> datas = new ArrayList<KeyedKingdomsObject>(this.cache.size());
            for (KeyedKingdomsObject data : this.cache.values()) {
                boolean isEmpty = data.isDataEmpty();
                if (isEmpty && !data.isNewData()) {
                    this.delete(data);
                    continue;
                }
                if (this.isSmartSaving() && (isEmpty || !data.shouldSave())) continue;
                datas.add(data);
            }
            this.database.save(datas);
            return datas.size();
        }
        Collection values = this.cache.values();
        this.database.save(values);
        return values.size();
    }

    public void loadAndSave(@NonNull T data) {
        this.cache(data, true);
        this.database.save(data);
    }

    public @Nullable T getOrLoadData(@NonNull K identifier) {
        KeyedKingdomsObject data = (KeyedKingdomsObject)this.cache.get(identifier);
        this.saveObjectState(data, false);
        return (T)data;
    }

    public T getDataIfLoaded(K key) {
        return (T)((KeyedKingdomsObject)this.cache.getIfPresent(key));
    }

    public boolean isLoaded(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    protected void unload(@NonNull T data) {
        super.unload(data);
        this.cache.remove(data.getKey());
    }

    public void cache(@NonNull T data, boolean newData) {
        Object key = data.getKey();
        data = (KeyedKingdomsObject)this.onLoad(data);
        this.cache.put(key, data);
        this.saveObjectState(data, newData);
        if (this.doesntExist != null) {
            this.doesntExist.invalidate(key);
        }
    }

    public @Nullable T peek(@NonNull K identifier) {
        KeyedKingdomsObject<Object> data = (KeyedKingdomsObject)this.cache.peek(identifier);
        if (data == null) {
            data = this.database.load(identifier);
        }
        return (T)data;
    }

    public boolean exists(K identifier) {
        if (this.doesntExist != null && this.doesntExist.getIfPresent(identifier) != null) {
            return false;
        }
        if (this.cache.containsKey(identifier)) {
            return true;
        }
        boolean exists = this.database.hasData(identifier);
        if (!exists && this.doesntExist != null) {
            this.doesntExist.put(identifier, (Object)true);
        }
        return exists;
    }

    @Override
    public int loadedCount() {
        return this.cache.size();
    }

    @Override
    public Collection<T> getLoadedData() {
        return this.cache.values();
    }

    @Override
    public Collection<T> peekAllData() {
        if (this.timedCache) {
            return this.getLoadedData();
        }
        Collection<K> keys = this.database.getAllDataKeys();
        ArrayList vals = new ArrayList(keys.size());
        vals.addAll(this.cache.values());
        HashSet<K> toLoad = new HashSet<K>(keys);
        toLoad.removeAll(this.cache.keySet());
        this.database.load(toLoad, vals::add);
        return vals;
    }
}

