/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.top.ExpressionBasedTopData;
import org.kingdoms.constants.top.common.NationTopData;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerNation;
import org.kingdoms.data.managers.GroupManager;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.string.QuantumString;

public final class NationManager
extends GroupManager<Nation> {
    private final Map<String, NationTopData> topData = new HashMap<String, NationTopData>();

    public NationManager(KingdomsDataCenter dataCenter) {
        super(Namespace.kingdoms("NATIONS"), dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_NATIONS.getString(), "nations", new DataHandlerNation()), false, dataCenter);
        this.configureTopData();
        this.createUpdateTask(KingdomsConfig.TOP_NATIONS_UPDATE_INTERVAL);
    }

    @Override
    public void configureTopData() {
        this.topData.clear();
        ExpressionBasedTopData.parse(KingdomsConfig.TOP_NATIONS_TYPES.getManager().getSection().getSection(), new Creator(), this.topData);
    }

    @Nullable
    public NationTopData getTopData(String name) {
        return this.topData.get(name);
    }

    @Override
    public Map<String, NationTopData> getTopData() {
        return this.topData;
    }

    @Override
    public QuantumString toQuantumName(String name) {
        return new QuantumString(name, !KingdomsConfig.NATION_NAME_CASE_SENSITIVE.getBoolean());
    }

    public Collection<Nation> getNations() {
        return this.peekAllData();
    }

    private static final class Creator
    implements ExpressionBasedTopData.Creator<NationTopData> {
        private Creator() {
        }

        @Override
        public NationTopData create(ConfigSection config, String name, Messenger displayName, Messenger description, MathExpression equation, ConditionalExpression filter) {
            return new NationTopData(equation, filter, name, displayName, description);
        }
    }
}

