/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerLand;
import org.kingdoms.data.managers.base.KeyedDataManager;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.main.Kingdoms;

public class LandManager
extends KeyedDataManager<SimpleChunkLocation, Land> {
    public static final Map<SimpleChunkLocation, List<CompletableFuture<Land>>> QUERIED_LANDS = new ConcurrentHashMap<SimpleChunkLocation, List<CompletableFuture<Land>>>(100);

    public LandManager(KingdomsDataCenter dataCenter) {
        super(Namespace.kingdoms("LANDS"), dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_LANDS.getString(), "lands", new DataHandlerLand()), true, dataCenter);
    }

    public CompletableFuture<Collection<Land>> getLands(Collection<SimpleChunkLocation> locations) {
        CompletableFuture<Collection<Land>> completableFuture = new CompletableFuture<Collection<Land>>();
        Kingdoms.taskScheduler().async().execute(() -> {
            ArrayList<Land> loaded = new ArrayList<Land>(locations.size());
            HashSet chosenLocs = locations;
            for (SimpleChunkLocation location : locations) {
                Land land = (Land)this.getDataIfLoaded(location);
                if (land == null) continue;
                loaded.add(land);
                if (chosenLocs == locations) {
                    chosenLocs = new HashSet(locations);
                }
                chosenLocs.remove(location);
            }
            if (chosenLocs.isEmpty()) {
                completableFuture.complete(loaded);
            } else {
                BulkChunkHandler handler = new BulkChunkHandler(chosenLocs, loaded, completableFuture);
                for (SimpleChunkLocation chosenLoc : chosenLocs) {
                    LandManager.queryLand(chosenLoc).thenAccept((Consumer)handler);
                }
            }
        });
        return completableFuture;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Land> queryLand(SimpleChunkLocation chunk) {
        List<CompletableFuture<Land>> query = QUERIED_LANDS.get(chunk);
        if (query == null) {
            query = new ArrayList<CompletableFuture<Land>>(1);
            QUERIED_LANDS.put(chunk, query);
        }
        CompletableFuture<Land> future = new CompletableFuture<Land>();
        query.add(future);
        return future;
    }

    private static final class BulkChunkHandler
    implements Consumer<Land> {
        private final Set<SimpleChunkLocation> locations;
        private final List<Land> loaded;
        private final CompletableFuture<Collection<Land>> completableFuture;

        private BulkChunkHandler(Set<SimpleChunkLocation> locations, List<Land> loaded, CompletableFuture<Collection<Land>> completableFuture) {
            this.locations = locations;
            this.loaded = loaded;
            this.completableFuture = completableFuture;
        }

        @Override
        public void accept(Land land) {
            this.loaded.add(land);
            this.locations.remove(land.getLocation());
            if (this.locations.isEmpty()) {
                this.completableFuture.complete(this.loaded);
            }
        }
    }
}

