/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.top.ExpressionBasedTopData;
import org.kingdoms.constants.top.common.KingdomTopData;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerKingdom;
import org.kingdoms.data.managers.GroupManager;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.string.QuantumString;

public final class KingdomManager
extends GroupManager<Kingdom> {
    private final Map<String, KingdomTopData> topData = new HashMap<String, KingdomTopData>();

    public KingdomManager(KingdomsDataCenter dataCenter) {
        super(Namespace.kingdoms("KINGDOMS"), dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_KINGDOMS.getString(), "kingdoms", new DataHandlerKingdom()), false, dataCenter);
        this.configureTopData();
        this.createUpdateTask(KingdomsConfig.TOP_KINGDOMS_UPDATE_INTERVAL);
    }

    @Override
    public void configureTopData() {
        this.topData.clear();
        ExpressionBasedTopData.parse(KingdomsConfig.TOP_KINGDOMS_TYPES.getManager().getSection().getSection(), new Creator(), this.topData);
    }

    @Nullable
    public KingdomTopData getTopData(String name) {
        return this.topData.get(name);
    }

    @Override
    public Map<String, KingdomTopData> getTopData() {
        return this.topData;
    }

    @Override
    public QuantumString toQuantumName(String name) {
        return new QuantumString(name, !KingdomsConfig.KINGDOM_NAME_CASE_SENSITIVE.getBoolean());
    }

    public Collection<Kingdom> getKingdoms() {
        return this.peekAllData();
    }

    private static final class Creator
    implements ExpressionBasedTopData.Creator<KingdomTopData> {
        private Creator() {
        }

        @Override
        public KingdomTopData create(ConfigSection config, String name, Messenger displayName, Messenger description, MathExpression equation, ConditionalExpression filter) {
            return new KingdomTopData(equation, filter, name, displayName, description);
        }
    }
}

