/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.KingdomsGlobals;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.handlers.DataHandlerGlobals;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.data.managers.base.SingularDataManager;
import org.kingdoms.dependencies.Dependency;

public class GlobalsDataManager
extends SingularDataManager<KingdomsGlobals> {
    private final KingdomsDataCenter dataCenter;

    public GlobalsDataManager(KingdomsDataCenter dataCenter) {
        super(Namespace.kingdoms("GLOBALS"), dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_GLOBALS.getString(), "globals", new DataHandlerGlobals()), dataCenter);
        this.dataCenter = dataCenter;
    }

    private boolean isUsingOldData() {
        DatabaseType databaseType = this.dataCenter.getDatabaseType();
        if (databaseType == DatabaseType.H2) {
            return Dependency.H2_DRIVER.getUsedVersion().getVersion().equals("2.1.214");
        }
        if (databaseType == DatabaseType.MySQL || databaseType == DatabaseType.SQLite || databaseType == DatabaseType.MariaDB) {
            return !((SQLDatabase)this.dataCenter.getKingdomManager().getDatabase()).columnExists("level");
        }
        return this.dataCenter.getKingdomPlayerManager().getDatabase().count() != 0;
    }

    @Override
    protected KingdomsGlobals onLoad(KingdomsGlobals globals) {
        globals = super.onLoad(globals);
        this.isUsingOldData();
        if (globals == null) {
            if (this.isUsingOldData()) {
                globals = new KingdomsGlobals(DataVersion.VERSION_0);
                DataVersion.setCurrentVersion(DataVersion.VERSION_0, true);
            } else {
                globals = new KingdomsGlobals(DataVersion.LATEST);
                DataVersion.setCurrentVersion(DataVersion.LATEST, true);
            }
        } else {
            DataVersion.setCurrentVersion(globals.getVersion(), true);
            KingdomsGlobals oldGlobals = globals;
            globals = globals.getUpdatedValues();
            globals.setPrevious(oldGlobals);
        }
        KingdomsGlobals.setInstance(globals);
        return globals;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((KingdomsGlobals)this.getOrLoadData()).setLastDisable(System.currentTimeMillis());
    }
}

