/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.history;

import java.util.Objects;
import org.kingdoms.constants.KingdomsGlobals;

public enum DataVersion {
    VERSION_0,
    VERSION_1;

    private static DataVersion version;
    private static final DataVersion[] VERSIONS;
    public static final DataVersion LATEST;

    public static void setCurrentVersion(DataVersion version, boolean raw) {
        DataVersion.version = version;
        if (raw) {
            return;
        }
        KingdomsGlobals.get().setVersion(version);
    }

    public static DataVersion getCurrentVersion() {
        return Objects.requireNonNull(version, "Version not set yet");
    }

    public boolean isLatest() {
        return this == LATEST;
    }

    public DataVersion next() {
        if (this.isLatest()) {
            return null;
        }
        return VERSIONS[this.ordinal() + 1];
    }

    static {
        VERSIONS = DataVersion.values();
        LATEST = VERSIONS[VERSIONS.length - 1];
    }
}

