/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.Set;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.enumeration.OrderedSet;

public final class DataHandlerRank {
    public static void serializeRank(Rank rank, SectionableDataSetter provider) {
        provider.setString("name", rank.getName());
        provider.setString("color", rank.getColor());
        provider.setString("symbol", rank.getSymbol());
        provider.setInt("priority", rank.getPriority());
        provider.setInt("maxClaims", rank.getMaxClaims());
        provider.setString("material", rank.getMaterial().name());
        provider.get("permissions").setCollection(rank.getPermissions(), (permProvider, value) -> permProvider.setString(value.getNamespace().asNormalizedString()));
        DataHandlerMetadata.serializeMetadata(provider, rank);
    }

    public static Rank deserializeRank(String node, SectionableDataGetter provider) {
        String name = provider.get("name").asString();
        String color = provider.get("color").asString();
        String symbol = provider.get("symbol").asString();
        int priority = provider.get("priority").asInt();
        int maxClaims = provider.get("maxClaims").asInt();
        XMaterial material = XMaterial.matchXMaterial((String)provider.get("material").asString()).orElse(XMaterial.DIRT);
        Set permissions = provider.get("permissions").asCollection(new OrderedSet(0), (perms, permProvider) -> {
            Namespace ns = Namespace.fromString(permProvider.asString());
            KingdomPermission permission = (KingdomPermission)((Object)Kingdoms.get().getPermissionRegistery().getRegistered(ns));
            if (permission == null) {
                KLogger.warn("Unknown permission when parsing data for rank '" + node + "': " + ns);
            } else {
                perms.add(permission);
            }
        });
        Rank rank = new Rank(node, name, color, symbol, material, priority, maxClaims, permissions);
        DataHandlerMetadata.deserializeMetadata(provider, rank);
        return rank;
    }
}

