/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandlerGroup;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerNation;", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "Ljava/util/UUID;", "Lorg/kingdoms/constants/group/Nation;", "<init>", "()V", "save", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "load", "json", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "id", "Companion", "core"})
public final class DataHandlerNation
extends KeyedDataHandler<UUID, Nation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final DataHandlerNation INSTANCE = new DataHandlerNation();

    public DataHandlerNation() {
        IdDataTypeHandler idDataTypeHandler = StdIdDataType.UUID;
        Object[] objectArray = new Object[]{"flag", "kingdoms", "capital", SQLDataHandlerProperties.Companion.ofLocation("home"), SQLDataHandlerProperties.Companion.ofSimpleLocation("nexus")};
        String[] stringArray = ArrayUtils.mergeObjects(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeObjects(...)");
        super(idDataTypeHandler, new SQLDataHandlerProperties(stringArray));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, @NotNull Nation data) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        provider.setUUID("capital", data.getCapitalId());
        SectionableDataSetter sectionableDataSetter = provider.get("kingdoms");
        Set<UUID> set = data.getMembers();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getMembers(...)");
        sectionableDataSetter.setCollection((Collection)set, DataHandlerNation::save$lambda$0);
        DataHandlerGroup.save(provider, data);
    }

    @Override
    @NotNull
    public Nation load(@NotNull SectionableDataGetter json, @NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        UUID capital = json.get("capital").asUUID();
        HashSet kingdoms = json.get("kingdoms").asCollection((Collection)new HashSet(), DataHandlerNation::load$lambda$1);
        DataHandlerGroup.GroupDataHolder $this$load_u24lambda_u242 = DataHandlerGroup.load(json, true);
        boolean bl = false;
        Map<UUID, KingdomRelationshipRequest> map = $this$load_u24lambda_u242.getRelationshipRequests();
        RankMap rankMap = $this$load_u24lambda_u242.getRanks();
        Map<UUID, KingdomRelation> map2 = $this$load_u24lambda_u242.getRelations();
        Set set = kingdoms;
        String string = $this$load_u24lambda_u242.getName();
        int n = $this$load_u24lambda_u242.getLevel();
        NamespacedMap<MathExpression> namespacedMap = $this$load_u24lambda_u242.getTaxes();
        SimpleLocation simpleLocation = $this$load_u24lambda_u242.getNexus();
        Location location = $this$load_u24lambda_u242.getHome();
        GroupBanner groupBanner = $this$load_u24lambda_u242.getFlag();
        GroupBanner groupBanner2 = $this$load_u24lambda_u242.getBanner();
        NamespacedMap<Color> namespacedMap2 = $this$load_u24lambda_u242.getColors();
        Balance balance = $this$load_u24lambda_u242.getResourcePoints();
        Balance balance2 = $this$load_u24lambda_u242.getBank();
        NamespacedFlags namespacedFlags = $this$load_u24lambda_u242.getFlags();
        Statistics statistics = $this$load_u24lambda_u242.getStats();
        long l = $this$load_u24lambda_u242.getSince();
        Shield shield = $this$load_u24lambda_u242.getShield();
        Map<KingdomRelation, Set<RelationAttribute>> map3 = $this$load_u24lambda_u242.getAttributes();
        Intrinsics.checkNotNull(map3);
        Nation nation = new Nation(id, map, rankMap, map2, set, capital, string, n, namespacedMap, simpleLocation, location, groupBanner, groupBanner2, namespacedMap2, balance, balance2, namespacedFlags, statistics, l, shield, map3);
        DataHandlerMetadata.deserializeMetadata(json, nation);
        return nation;
    }

    private static final void save$lambda$0(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void load$lambda$1(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        set.add(uUID);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerNation$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/kingdoms/data/handlers/DataHandlerNation;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

