/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.Collection;
import java.util.LinkedList;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0007J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\u0001H\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerLogs;", "", "<init>", "()V", "load", "Ljava/util/LinkedList;", "Lorg/kingdoms/constants/group/model/logs/AuditLog;", "sectionProvider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "identifier", "save", "", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "logs", "core"})
public final class DataHandlerLogs {
    @NotNull
    public static final DataHandlerLogs INSTANCE = new DataHandlerLogs();

    private DataHandlerLogs() {
    }

    @JvmStatic
    @NotNull
    public static final LinkedList<AuditLog> load(@NotNull SectionableDataGetter sectionProvider, @NotNull Object identifier) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return sectionProvider.get("logs").asCollection((Collection)new LinkedList(), (arg_0, arg_1) -> DataHandlerLogs.load$lambda$0(identifier, arg_0, arg_1));
    }

    @JvmStatic
    public static final void save(@NotNull SectionableDataSetter sectionProvider, @NotNull LinkedList<AuditLog> logs, @NotNull Object identifier) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        sectionProvider.get("logs").setCollection((Collection)logs, DataHandlerLogs::save$lambda$2);
    }

    private static final void load$lambda$0(Object $identifier, LinkedList logs, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)logs, (String)"logs");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.get("namespace").asString();
        Intrinsics.checkNotNull((Object)string);
        Namespace namespace = Namespace.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace ns = namespace;
        AuditLogProvider provider = (AuditLogProvider)((Object)Kingdoms.get().getAuditLogRegistry().getRegistered(ns));
        if (provider == null) {
            KLogger.warn("No log provider found for '" + ns + "' for " + $identifier);
            return;
        }
        try {
            AuditLog auditLog = provider.construct();
            Intrinsics.checkNotNullExpressionValue((Object)auditLog, (String)"construct(...)");
            AuditLog auditLog2 = auditLog;
            auditLog2.deserialize(new DeserializationContext<DataGetter>(element));
            logs.add(auditLog2);
        }
        catch (Throwable ex) {
            KLogger.error("Error while deserializing " + ns.asString() + " log:");
            ex.printStackTrace();
        }
    }

    private static final void save$lambda$2(SectionCreatableDataSetter elementProvider, AuditLog element) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SectionableDataSetter $this$save_u24lambda_u242_u24lambda_u241 = sectionableDataSetter = elementProvider.createSection();
        boolean bl = false;
        $this$save_u24lambda_u242_u24lambda_u241.setString("namespace", element.getProvider().getNamespace().asNormalizedString());
        element.serialize(new SerializationContext<DataSetter>($this$save_u24lambda_u242_u24lambda_u241));
    }
}

