/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.HashMap;
import java.util.Map;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.constants.stats.StatRegistry;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J\u001c\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerKingdomsObject;", "", "<init>", "()V", "save", "", "sectionProvider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "obj", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "load", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "saveStats", "stats", "Lorg/kingdoms/constants/stats/Statistics;", "loadStats", "saveFlags", "flags", "Lorg/kingdoms/constants/namespace/NamespacedFlags;", "loadFlags", "core"})
public final class DataHandlerKingdomsObject {
    @NotNull
    public static final DataHandlerKingdomsObject INSTANCE = new DataHandlerKingdomsObject();

    private DataHandlerKingdomsObject() {
    }

    @JvmStatic
    public static final void save(@NotNull SectionableDataSetter sectionProvider, @NotNull KeyedKingdomsObject<?> obj) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        DataHandlerMetadata.serializeMetadata(sectionProvider, obj);
    }

    @JvmStatic
    public static final void load(@NotNull SectionableDataGetter sectionProvider, @NotNull KeyedKingdomsObject<?> obj) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        DataHandlerMetadata.deserializeMetadata(sectionProvider, obj);
    }

    @JvmStatic
    public static final void saveStats(@NotNull SectionableDataSetter sectionProvider, @NotNull Statistics stats) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        sectionProvider.setMap(stats, DataHandlerKingdomsObject::saveStats$lambda$0);
    }

    @JvmStatic
    @NotNull
    public static final Statistics loadStats(@NotNull SectionableDataGetter sectionProvider) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Statistics stats = new Statistics();
        sectionProvider.asMap((Map)new HashMap(), (arg_0, arg_1, arg_2) -> DataHandlerKingdomsObject.loadStats$lambda$1(stats, arg_0, arg_1, arg_2));
        return stats;
    }

    @JvmStatic
    public static final void saveFlags(@NotNull SectionableDataSetter sectionProvider, @NotNull NamespacedFlags flags) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        sectionProvider.setMap(flags, DataHandlerKingdomsObject::saveFlags$lambda$2);
    }

    @JvmStatic
    @NotNull
    public static final NamespacedFlags loadFlags(@NotNull SectionableDataGetter sectionProvider) {
        Intrinsics.checkNotNullParameter((Object)sectionProvider, (String)"sectionProvider");
        NamespacedFlags flags = new NamespacedFlags(DefaultDataFlags.Groups.DEFAULTS);
        sectionProvider.asMap((Map)new HashMap(), (arg_0, arg_1, arg_2) -> DataHandlerKingdomsObject.loadFlags$lambda$3(flags, arg_0, arg_1, arg_2));
        return flags;
    }

    private static final void saveStats$lambda$0(Namespace key, MappedIdSetter keyProvider, Stat value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        keyProvider.setString(key.asNormalizedString());
        StatRegistry.serializeStat(value, keyProvider.getValueProvider().createSection());
    }

    private static final void loadStats$lambda$1(Statistics $stats, HashMap hashMap, DataGetter keyProvider, SectionableDataGetter valueProvider) {
        String string = keyProvider.asString();
        Intrinsics.checkNotNull((Object)string);
        Namespace namespace = Namespace.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace ns = namespace;
        Map map = $stats;
        Intrinsics.checkNotNull((Object)valueProvider);
        map.put(ns, StatRegistry.deserializeStat(valueProvider));
    }

    private static final void saveFlags$lambda$2(Namespace key, MappedIdSetter keyProvider, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key.asNormalizedString());
        keyProvider.getValueProvider().setBoolean(value);
    }

    private static final void loadFlags$lambda$3(NamespacedFlags $flags, HashMap hashMap, DataGetter keyProvider, SectionableDataGetter valueProvider) {
        String string = keyProvider.asString();
        Intrinsics.checkNotNull((Object)string);
        Namespace namespace = Namespace.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace ns = namespace;
        ((Map)$flags).put(ns, valueProvider.asBoolean());
    }
}

