/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandlerKingdomsObject;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;

public final class DataHandlerKingdomPlayer
extends KeyedDataHandler<UUID, KingdomPlayer> {
    public static final DataHandlerKingdomPlayer INSTANCE = new DataHandlerKingdomPlayer();

    public DataHandlerKingdomPlayer() {
        super(StdIdDataType.UUID, new SQLDataHandlerProperties(new String[]{"power", "lastPowerCheckup", "chatChannel", "mapSize_height", "mapSize_width"}));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, KingdomPlayer data) {
        provider.setUUID("kingdom", data.getKingdomId());
        provider.setString("lang", data.getLanguage().asDataString());
        provider.setString("rank", data.getRankNode());
        provider.setString("nationalRank", data.getNationRankNode());
        if (data.getChatChannelId() != null) {
            provider.setString("chatChannel", data.getChatChannel().getDataId());
        }
        provider.setLong("joinedAt", data.getJoinedAt());
        provider.setString("markersType", data.getMarkersType());
        if (KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
            provider.setDouble("power", data.getPower());
            provider.setLong("lastPowerCheckup", data.getLastPowerCheckup());
        }
        provider.setLong("lastDonationTime", data.getLastDonationTime());
        provider.setDouble("lastDonationAmount", data.getLastDonationAmount());
        provider.setDouble("totalDonations", data.getTotalDonations());
        provider.setString("markersType", data.getMarkersType());
        DataHandlerKingdomsObject.saveFlags(provider.get("flags"), data.getFlags());
        Pair<Integer, Integer> mapSize = data.getMapSize();
        if (mapSize != null) {
            SectionableDataSetter mapSizeProvider = provider.createSection("mapSize");
            mapSizeProvider.setInt("height", mapSize.getKey());
            mapSizeProvider.setInt("width", mapSize.getValue());
        }
        provider.get("invites").setMap(data.getInvites(), (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
            valueProvider.setUUID("sender", value.getSender());
            valueProvider.setLong("acceptTime", value.getAcceptTime().toMillis());
            valueProvider.setLong("timestamp", value.getTimestamp());
        });
        provider.get("claims").setCollection(data.getClaims(), DataSetter::setSimpleChunkLocation);
        provider.get("mutedChannels").setCollection(data.getMutedChannels(), DataSetter::setString);
        provider.get("readMails").setCollection(data.getReadMails(), DataSetter::setUUID);
        DataHandlerKingdomsObject.save(provider, data);
    }

    @Override
    public KingdomPlayer load(@NotNull SectionableDataGetter provider, UUID id) {
        NamespacedFlags flags;
        String langName = provider.getString("lang");
        Language language = langName != null ? SupportedLanguage.valueOf(langName) : LanguageManager.getDefaultLanguage();
        UUID kingdom = provider.get("kingdom").asUUID();
        String rank = provider.getString("rank");
        String nationalRank = provider.getString("nationalRank");
        String markersType = provider.getString("markersType");
        String channel = provider.get("chatChannel").asString((Function0<String>)((Function0)() -> "GLOBAL"));
        double power = provider.getDouble("power");
        long lastPowerCheckup = provider.getLong("lastPowerCheckup");
        long joinedAt = provider.getLong("joinedAt");
        long lastDonationTime = provider.getLong("lastDonationTime");
        double lastDonationAmount = provider.getDouble("lastDonationAmount");
        double totalDonations = provider.getDouble("totalDonations");
        Set readMails = provider.get("readMails").asCollection(new HashSet(), (c, e) -> c.add(e.asUUID()));
        Set mutedChannels = provider.get("mutedChannels").asCollection(new HashSet(), (c, e) -> c.add(e.asString()));
        Set claims = provider.get("claims").asCollection(new HashSet(), (c, e) -> c.add(e.asSimpleChunkLocation()));
        HashSet<SimpleLocation> protectedBlocks = new HashSet<SimpleLocation>();
        SectionableDataGetter mapSizeSection = provider.get("mapSize").asSection();
        int mapHeight = mapSizeSection.getInt("height");
        int mapWidth = mapSizeSection.getInt("width");
        Pair<Integer, Integer> mapSize = mapHeight == 0 || mapWidth == 0 ? null : Pair.of(mapHeight, mapWidth);
        HashMap invites = provider.get("invites").asMap(new HashMap(), (m, k, v) -> m.put(k.asUUID(), new KingdomInvite(v.get("sender").asUUID(), v.getLong("acceptTime"), v.getLong("timestamp"))));
        if (DataVersion.getCurrentVersion() == DataVersion.VERSION_0) {
            flags = new NamespacedFlags(DefaultDataFlags.Players.DEFAULTS);
            flags.put(DefaultDataFlags.Players.ADMIN, Boolean.valueOf(provider.getBoolean("admin")));
            flags.put(DefaultDataFlags.Players.PVP, Boolean.valueOf(provider.getBoolean("pvp")));
            flags.put(DefaultDataFlags.Players.MARKERS, Boolean.valueOf(provider.getBoolean("markers")));
            flags.put(DefaultDataFlags.Players.SNEAK_MODE, Boolean.valueOf(provider.getBoolean("sneakMode")));
            flags.put(DefaultDataFlags.Players.SPY, Boolean.valueOf(provider.getBoolean("spy")));
        } else {
            flags = DataHandlerKingdomsObject.loadFlags(provider.get("flags"));
        }
        KingdomPlayer kp = new KingdomPlayer(id, kingdom, language, rank, nationalRank, channel, markersType, joinedAt, power, lastDonationTime, lastDonationAmount, totalDonations, lastPowerCheckup, readMails, invites, claims, mapSize, flags, mutedChannels, protectedBlocks);
        DataHandlerKingdomsObject.load(provider, kp);
        return kp;
    }
}

