/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.statements.setters;

import com.google.gson.JsonElement;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.database.sql.statements.SQLUpsert;
import org.kingdoms.data.database.sql.statements.setters.SetterInfo;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.postgresql.util.PGobject;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.gson.KingdomsGson;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J$\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001fH\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&J\b\u0010\u0016\u001a\u00020\u0019H\u0002J\u0006\u0010'\u001a\u00020\u0019J\b\u0010(\u001a\u00020\u0019H\u0002J\b\u0010)\u001a\u00020\u0019H\u0002J\u0006\u0010*\u001a\u00020\u0019J\u001a\u0010+\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010-\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0018\u0010.\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u00010/J\u0018\u00100\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010,\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010,\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0014H\u0016J\u0018\u00105\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010,\u001a\u000206H\u0016J\u001a\u00107\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u000108H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "associateNamedData", "", "", "", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/util/Map;)V", "operations", "", "Lorg/kingdoms/data/database/sql/statements/setters/SetterInfo;", "statement", "Ljava/sql/PreparedStatement;", "getStatement", "()Ljava/sql/PreparedStatement;", "setStatement", "(Ljava/sql/PreparedStatement;)V", "initialized", "", "batch", "setParameters", "", "addParameterIfNotExist", "", "parameterName", "addParameter", "addOperation", "parameter", "operation", "Lorg/kingdoms/libs/kotlin/Function1;", "checkInitialized", "getIndex", "name", "buildStatement", "table", "connection", "Ljava/sql/Connection;", "execute", "resetBatch", "nullRemainingParameters", "addBatch", "setString", "value", "setInt", "setJson", "Lcom/google/gson/JsonElement;", "setFloat", "", "setLong", "", "setBoolean", "setDouble", "", "setUUID", "Ljava/util/UUID;", "core"})
@SourceDebugExtension(value={"SMAP\nPreparedNamedSetterStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreparedNamedSetterStatement.kt\norg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n487#2,7:200\n216#3,2:207\n1#4:209\n*S KotlinDebug\n*F\n+ 1 PreparedNamedSetterStatement.kt\norg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement\n*L\n129#1:200,7\n130#1:207,2\n*E\n"})
public final class PreparedNamedSetterStatement
implements SimplePreparedStatement {
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final List<SetterInfo> operations;
    public PreparedStatement statement;
    private boolean initialized;
    private boolean batch;
    @NotNull
    private final Map<String, Integer> associateNamedData;
    @NotNull
    private Set<String> setParameters;

    public PreparedNamedSetterStatement(@NotNull DatabaseType databaseType, @NotNull Map<String, Integer> associateNamedData) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter(associateNamedData, (String)"associateNamedData");
        this.databaseType = databaseType;
        this.operations = new ArrayList(30);
        this.associateNamedData = new LinkedHashMap<String, Integer>(associateNamedData);
        this.setParameters = new HashSet();
    }

    @NotNull
    public final PreparedStatement getStatement() {
        PreparedStatement preparedStatement = this.statement;
        if (preparedStatement != null) {
            return preparedStatement;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"statement");
        return null;
    }

    public final void setStatement(@NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"<set-?>");
        this.statement = preparedStatement;
    }

    public final void addParameterIfNotExist(@NotNull String parameterName) {
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        if (!this.associateNamedData.containsKey(parameterName)) {
            this.addParameter(parameterName);
        }
    }

    private final void addParameter(String parameterName) {
        this.associateNamedData.put(parameterName, this.associateNamedData.size() + 1);
    }

    private final void addOperation(String parameter, Function1<? super Integer, Unit> operation) {
        this.setParameters.add(parameter);
        if (this.initialized) {
            operation.invoke((Object)this.getIndex(parameter));
        } else {
            this.operations.add(new SetterInfo(parameter, operation));
        }
    }

    private final void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Statement not built yet");
        }
    }

    private final int getIndex(String name) {
        Integer n = this.associateNamedData.get(name);
        if (n == null) {
            throw new IllegalStateException("Unknown parameter index for: " + name + " (" + this.associateNamedData + ')');
        }
        return n;
    }

    public final void buildStatement(@NotNull String table, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (this.initialized) {
            return;
        }
        StringJoiner parameterNamesJoiner = new StringJoiner(", ");
        StringJoiner preparedParameterJoiner = new StringJoiner(", ");
        for (String key : this.associateNamedData.keySet()) {
            parameterNamesJoiner.add('`' + key + '`');
            preparedParameterJoiner.add("?");
        }
        for (SetterInfo op : this.operations) {
            String paramName = op.getName();
            if (this.associateNamedData.containsKey(paramName)) continue;
            this.addParameter(paramName);
            parameterNamesJoiner.add('`' + paramName + '`');
            preparedParameterJoiner.add("?");
        }
        String string = parameterNamesJoiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = preparedParameterJoiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String query = this.databaseType.createStatement(new SQLUpsert(string, string2), table);
        try {
            this.setStatement(connection.prepareStatement(query));
        }
        catch (Throwable e) {
            KLogger.error("Failed to build setter statement with query: " + query);
            throw e;
        }
        this.initialized = true;
    }

    private final void setParameters() {
        for (SetterInfo op : this.operations) {
            try {
                int index = this.getIndex(op.getName());
                op.getOperation().invoke((Object)index);
            }
            catch (Throwable ex) {
                RuntimeException newEx = new RuntimeException(ex);
                newEx.setStackTrace(op.getStacktrace().getStackTrace());
                throw new RuntimeException(newEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        this.checkInitialized();
        AutoCloseable autoCloseable = this.getStatement();
        Throwable throwable = null;
        try {
            Serializable serializable;
            PreparedStatement it = (PreparedStatement)autoCloseable;
            boolean bl = false;
            if (this.batch) {
                serializable = (Serializable)this.getStatement().executeBatch();
            } else {
                this.setParameters();
                this.nullRemainingParameters();
                serializable = Boolean.valueOf(this.getStatement().execute());
            }
            Serializable serializable2 = serializable;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void resetBatch() {
        this.getStatement().clearParameters();
    }

    private final void nullRemainingParameters() {
        Map<String, Integer> $this$filterKeys$iv = this.associateNamedData;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            String x = entry$iv.getKey();
            boolean bl = false;
            if (!(!this.setParameters.contains(x))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            this.getStatement().setObject(((Number)entry.getValue()).intValue(), null);
        }
        this.setParameters = new HashSet();
    }

    public final void addBatch() {
        this.checkInitialized();
        if (!this.batch) {
            this.setParameters();
        }
        this.nullRemainingParameters();
        this.getStatement().addBatch();
        this.resetBatch();
        this.batch = true;
    }

    @Override
    public void setString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setString$lambda$3(this, value, arg_0)));
    }

    @Override
    public void setInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setInt$lambda$4(this, value, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final void setJson(@NotNull String name, @Nullable JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (WhenMappings.$EnumSwitchMapping$0[this.databaseType.ordinal()]) {
            case 1: {
                this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setJson$lambda$6(this, value, arg_0)));
                break;
            }
            case 2: {
                this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setJson$lambda$7(value, this, arg_0)));
                break;
            }
            default: {
                String string;
                PreparedNamedSetterStatement preparedNamedSetterStatement = this;
                String string2 = name;
                JsonElement jsonElement = value;
                if (jsonElement != null) {
                    void it;
                    JsonElement jsonElement2 = jsonElement;
                    String string3 = string2;
                    PreparedNamedSetterStatement preparedNamedSetterStatement2 = preparedNamedSetterStatement;
                    boolean bl = false;
                    String string4 = KingdomsGson.toString((JsonElement)it);
                    preparedNamedSetterStatement = preparedNamedSetterStatement2;
                    string2 = string3;
                    string = string4;
                } else {
                    string = null;
                }
                preparedNamedSetterStatement.setString(string2, string);
            }
        }
    }

    @Override
    public void setFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setFloat$lambda$9(this, value, arg_0)));
    }

    @Override
    public void setLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setLong$lambda$10(this, value, arg_0)));
    }

    @Override
    public void setBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setBoolean$lambda$11(this, value, arg_0)));
    }

    @Override
    public void setDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setDouble$lambda$12(this, value, arg_0)));
    }

    @Override
    public void setUUID(@NotNull String name, @Nullable UUID value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PreparedNamedSetterStatement.setUUID$lambda$13(this, value, arg_0)));
    }

    private static final Unit setString$lambda$3(PreparedNamedSetterStatement this$0, String $value, int index) {
        this$0.getStatement().setString(index, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setInt$lambda$4(PreparedNamedSetterStatement this$0, int $value, int index) {
        this$0.getStatement().setInt(index, $value);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit setJson$lambda$6(PreparedNamedSetterStatement this$0, JsonElement $value, int index) {
        byte[] byArray;
        PreparedStatement preparedStatement = this$0.getStatement();
        int n = index;
        JsonElement jsonElement = $value;
        if (jsonElement != null) {
            void it;
            JsonElement jsonElement2 = jsonElement;
            int n2 = n;
            PreparedStatement preparedStatement2 = preparedStatement;
            boolean bl = false;
            String string = KingdomsGson.toString((JsonElement)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] byArray3 = byArray2;
            preparedStatement = preparedStatement2;
            n = n2;
            byArray = byArray3;
        } else {
            byArray = null;
        }
        preparedStatement.setBytes(n, byArray);
        return Unit.INSTANCE;
    }

    private static final Unit setJson$lambda$7(JsonElement $value, PreparedNamedSetterStatement this$0, int index) {
        PGobject jsonObject = new PGobject();
        jsonObject.setType("json");
        JsonElement jsonElement = $value;
        jsonObject.setValue((String)(jsonElement == null ? null : KingdomsGson.toString(jsonElement)));
        this$0.getStatement().setObject(index, jsonObject);
        return Unit.INSTANCE;
    }

    private static final Unit setFloat$lambda$9(PreparedNamedSetterStatement this$0, float $value, int index) {
        this$0.getStatement().setFloat(index, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setLong$lambda$10(PreparedNamedSetterStatement this$0, long $value, int index) {
        this$0.getStatement().setLong(index, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setBoolean$lambda$11(PreparedNamedSetterStatement this$0, boolean $value, int index) {
        this$0.getStatement().setBoolean(index, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setDouble$lambda$12(PreparedNamedSetterStatement this$0, double $value, int index) {
        this$0.getStatement().setDouble(index, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setUUID$lambda$13(PreparedNamedSetterStatement this$0, UUID $value, int index) {
        if (this$0.databaseType == DatabaseType.PostgreSQL) {
            this$0.getStatement().setObject(index, $value);
        } else {
            UUID uUID = $value;
            this$0.getStatement().setBytes(index, uUID == null ? null : SQLDatabase.Companion.asBytes(uUID));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.H2.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.PostgreSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

