/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.schema;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.schema.SQLSchemaReader;
import org.kingdoms.libs.intellij.lang.annotations.Language;
import org.kingdoms.libs.kotlin.text.MatchGroup;
import org.kingdoms.libs.kotlin.text.MatchGroupCollection;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.utils.string.Strings;

public final class SQLSchemaProcessor {
    @Language(value="RegExp")
    private static final String NULLABLE = "( +(?:NOT )?NULL)?";
    @Language(value="RegExp")
    private static final String NOTHING_BEHIND = "(?<!\\w)";
    private static final Regex LOCAION_TYPE = SQLSchemaProcessor.compile("Location\\((\\w+)\\)");
    private static final Regex SIMPLE_LOCATION_TYPE = SQLSchemaProcessor.compile("SimpleLocation\\((\\w+)\\)");
    private static final Regex SIMPLE_CHUNK_LOCATION_TYPE = SQLSchemaProcessor.compile("SimpleChunkLocation\\((\\w+)\\)");

    public static void runSchema(DatabaseType databaseType, InputStream schema, Supplier<Connection> getConnection) {
        try {
            String executePragma = databaseType == DatabaseType.SQLite ? "PRAGMA strict=ON" : null;
            List<String> statements = new SQLSchemaReader().getStatements(schema);
            try (Connection connection = getConnection.get();
                 Statement statement = connection.createStatement();){
                for (String query : statements) {
                    if (executePragma != null) {
                        statement.addBatch(executePragma);
                        executePragma = null;
                    }
                    query = SQLSchemaProcessor.globalSchemaProcessor(query);
                    query = databaseType.processCommands(query);
                    statement.addBatch(query);
                }
                statement.executeBatch();
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String replacePrefix(String query) {
        return Strings.replace(query, "{PREFIX}", KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_');
    }

    private static Regex compile(@Language(value="RegExp") String pattern) {
        return new Regex(Pattern.compile(NOTHING_BEHIND + pattern + NULLABLE));
    }

    private static String replace(Regex pattern, String query, String ... fragments) {
        return pattern.replace((CharSequence)query, matcher -> {
            MatchGroupCollection groups = matcher.getGroups();
            String prefix = groups.get(1).getValue();
            MatchGroup nullGroup = groups.get(2);
            String nullability = nullGroup == null ? "" : nullGroup.getValue();
            StringJoiner builder = new StringJoiner(", ");
            for (String fragment : fragments) {
                builder.add(prefix + '_' + fragment + nullability);
            }
            return builder.toString();
        });
    }

    private static String globalSchemaProcessor(String query) {
        query = SQLSchemaProcessor.replacePrefix(query);
        query = SQLSchemaProcessor.replace(LOCAION_TYPE, query, "world WORLD", "x DOUBLE", "y DOUBLE", "z DOUBLE", "yaw FLOAT", "pitch FLOAT");
        query = SQLSchemaProcessor.replace(SIMPLE_LOCATION_TYPE, query, "world WORLD", "x INT", "y INT", "z INT");
        query = SQLSchemaProcessor.replace(SIMPLE_CHUNK_LOCATION_TYPE, query, "world WORLD", "x INT", "z INT");
        query = Strings.replace(query, "WORLD", "VARCHAR(64)");
        query = Strings.replace(query, "RANK_NODE", "VARCHAR(50)");
        query = Strings.replace(query, "RANK_NAME", "NVARCHAR(100)");
        query = Strings.replace(query, "COLOR", "VARCHAR(30)");
        return query;
    }
}

