/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Enumeration;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.libs.hikari.HikariConfig;
import org.kingdoms.libs.hikari.HikariDataSource;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.main.KLogger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/data/database/sql/connection/SQLHikariConnectionProvider;", "Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "hikari", "Lorg/kingdoms/libs/hikari/HikariDataSource;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Lcom/zaxxer/hikari/HikariDataSource;)V", "deregisterDriver", "", "driverClassName", "", "getConnection", "Ljava/sql/Connection;", "connect", "close", "core"})
@SourceDebugExtension(value={"SMAP\nSQLConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLConnectionProvider.kt\norg/kingdoms/data/database/sql/connection/SQLHikariConnectionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class SQLHikariConnectionProvider
extends SQLConnectionProvider {
    @NotNull
    private final HikariDataSource hikari;

    public SQLHikariConnectionProvider(@NotNull DatabaseType databaseType, @NotNull HikariDataSource hikari) {
        HikariDataSource hikariDataSource;
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)hikari, (String)"hikari");
        super(databaseType);
        this.hikari = hikari;
        HikariDataSource $this$_init__u24lambda_u240 = hikariDataSource = this.hikari;
        boolean bl = false;
        DatabaseProperties dbProps = DatabaseProperties.Companion.defaults(databaseType);
        $this$_init__u24lambda_u240.setJdbcUrl("jdbc:" + databaseType.getDriverJdbcIdentifier() + "://" + dbProps.getAddress() + ':' + dbProps.getPort() + '/' + dbProps.getDatabaseName());
        $this$_init__u24lambda_u240.setDriverClassName(databaseType.getDriverClassName());
        databaseType.applyProperties((HikariConfig)this.hikari, dbProps);
        if (KLogger.isDebugging()) {
            $this$_init__u24lambda_u240.setLeakDetectionThreshold(Duration.ofSeconds(30L).toMillis());
        }
        $this$_init__u24lambda_u240.setPoolName("kingdoms-hikari");
        $this$_init__u24lambda_u240.setMaximumPoolSize(KingdomsConfig.DATABASE_POOL_SETTINGS_SIZE_MAX.getInt());
        $this$_init__u24lambda_u240.setMinimumIdle(KingdomsConfig.DATABASE_POOL_SETTINGS_MINIMUM_IDLE.getInt());
        Duration duration = KingdomsConfig.DATABASE_POOL_SETTINGS_MAXIMUM_LIFETIME.getTime();
        Intrinsics.checkNotNull((Object)duration);
        $this$_init__u24lambda_u240.setMaxLifetime(duration.toMillis());
        Duration duration2 = KingdomsConfig.DATABASE_POOL_SETTINGS_KEEPALIVE_TIME.getTime();
        Intrinsics.checkNotNull((Object)duration2);
        $this$_init__u24lambda_u240.setKeepaliveTime(duration2.toMillis());
        Duration duration3 = KingdomsConfig.DATABASE_POOL_SETTINGS_CONNECTION_TIMEOUT.getTime();
        Intrinsics.checkNotNull((Object)duration3);
        $this$_init__u24lambda_u240.setConnectionTimeout(duration3.toMillis());
        this.deregisterDriver(databaseType.getDriverClassName());
    }

    private final void deregisterDriver(String driverClassName) {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getDrivers(...)");
        Enumeration<Driver> drivers = enumeration;
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!Intrinsics.areEqual((Object)driver.getClass().getName(), (Object)driverClassName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Connection connection;
        try {
            connection = this.hikari.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while attempting to get connection from: " + (Object)((Object)this.getDatabaseType()) + "::" + this.hikari, e);
        }
        Connection connection2 = connection;
        if (connection2 == null) {
            boolean bl = false;
            String string = "Unable to get a connection from the pool from " + (Object)((Object)this.getDatabaseType()) + "::" + this.hikari;
            throw new IllegalStateException(string.toString());
        }
        return connection2;
    }

    @Override
    public void connect() {
        this.getConnection().close();
    }

    @Override
    public void close() {
        this.hikari.close();
    }
}

