/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataGetterProvider;
import org.kingdoms.data.database.sql.SQLDataSetterProvider;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.data.database.sql.statements.getters.SimpleResultSetQuery;
import org.kingdoms.data.database.sql.statements.setters.PreparedNamedSetterStatement;
import org.kingdoms.data.database.sql.statements.setters.RawSimplePreparedStatement;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.string.Strings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006B3\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J$\u0010\u0015\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001cH\u0016J\u0015\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0014H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010$2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'H\u0016J\u0016\u0010(\u001a\u00020\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/kingdoms/data/database/sql/base/KeyedSQLDatabase;", "K", "", "T", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "Lorg/kingdoms/data/database/sql/base/SQLDatabase;", "Lorg/kingdoms/data/database/base/KeyedKingdomsDatabase;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "table", "", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "connectionProvider", "Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;)V", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "totalDataCount", "", "load", "key", "(Ljava/lang/Object;)Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "", "keys", "", "handler", "Ljava/util/function/Consumer;", "delete", "(Ljava/lang/Object;)V", "hasData", "", "(Ljava/lang/Object;)Z", "count", "getAllDataKeys", "", "loadAllData", "filter", "Ljava/util/function/Predicate;", "save", "datas", "core"})
@SourceDebugExtension(value={"SMAP\nKeyedSQLDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyedSQLDatabase.kt\norg/kingdoms/data/database/sql/base/KeyedSQLDatabase\n+ 2 SQLDatabase.kt\norg/kingdoms/data/database/sql/base/SQLDatabase\n*L\n1#1,208:1\n86#2,9:209\n86#2,9:218\n86#2,9:227\n86#2,9:236\n100#2,11:245\n100#2,11:256\n86#2,9:267\n*S KotlinDebug\n*F\n+ 1 KeyedSQLDatabase.kt\norg/kingdoms/data/database/sql/base/KeyedSQLDatabase\n*L\n32#1:209,9\n60#1:218,9\n91#1:227,9\n109#1:236,9\n118#1:245,11\n131#1:256,11\n146#1:267,9\n*E\n"})
public final class KeyedSQLDatabase<K, T extends KeyedKingdomsObject<K>>
extends SQLDatabase<T>
implements KeyedKingdomsDatabase<K, T> {
    @NotNull
    private final KeyedDataHandler<K, T> dataHandler;
    private int totalDataCount;

    public KeyedSQLDatabase(@NotNull DatabaseType databaseType, @NotNull String table, @NotNull KeyedDataHandler<K, T> dataHandler, @NotNull SQLConnectionProvider connectionProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        super(databaseType, table, connectionProvider);
        this.dataHandler = dataHandler;
        this.totalDataCount = 10;
    }

    @NotNull
    protected KeyedDataHandler<K, T> getDataHandler() {
        return this.dataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T load(@NotNull K key) {
        AutoCloseable autoCloseable;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Objects.requireNonNull(key);
        String query = "SELECT * FROM `" + this.getTable() + "` WHERE " + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getWhereClause();
        SQLDatabase this_$iv = this;
        boolean $i$f$prepareStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable2 = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                KeyedKingdomsObject keyedKingdomsObject;
                AutoCloseable autoCloseable3;
                Connection connection$iv = (Connection)autoCloseable2;
                boolean bl = false;
                AutoCloseable autoCloseable4 = connection$iv.prepareStatement(query$iv);
                Throwable throwable2 = null;
                try {
                    KeyedKingdomsObject keyedKingdomsObject2;
                    block19: {
                        PreparedStatement ps = (PreparedStatement)autoCloseable4;
                        boolean bl2 = false;
                        ((KeyedDataHandler)this.getDataHandler()).getIdHandler().setSQL(new RawSimplePreparedStatement(this.getDatabaseType(), ps), key);
                        autoCloseable3 = ps.executeQuery();
                        Throwable throwable3 = null;
                        try {
                            ResultSet result = (ResultSet)autoCloseable3;
                            boolean bl3 = false;
                            if (!result.next()) {
                                KeyedKingdomsObject keyedKingdomsObject3 = null;
                                keyedKingdomsObject2 = keyedKingdomsObject3;
                                break block19;
                            }
                            DatabaseType databaseType = this.getDatabaseType();
                            String string = this.getTable();
                            DatabaseType databaseType2 = this.getDatabaseType();
                            Intrinsics.checkNotNull((Object)result);
                            SQLDataGetterProvider provider = new SQLDataGetterProvider(databaseType, string, null, false, false, new SimpleResultSetQuery(databaseType2, result));
                            KeyedKingdomsObject keyedKingdomsObject4 = (KeyedKingdomsObject)((KeyedDataHandler)this.getDataHandler()).load(provider, key);
                            keyedKingdomsObject2 = keyedKingdomsObject4;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                        }
                    }
                    keyedKingdomsObject = keyedKingdomsObject2;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable4, (Throwable)throwable2);
                }
                autoCloseable3 = keyedKingdomsObject;
                autoCloseable = autoCloseable3;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
        return (T)autoCloseable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Collection<K> keys, @NotNull Consumer<T> handler) {
        String inClause;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (keys.isEmpty()) {
            return;
        }
        int columnCount = ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getColumns().length;
        String string = inClause = Strings.repeat('(' + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getInClause() + "),", keys.size());
        Intrinsics.checkNotNull((Object)string);
        int n = 0;
        int n2 = inClause.length() - 1;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        inClause = string2;
        String query = "SELECT * FROM `" + this.getTable() + "` WHERE (" + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getColumnsTuple() + ") IN(" + inClause + ')';
        SQLDatabase this_$iv = this;
        boolean $i$f$prepareStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                Unit unit;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection$iv.prepareStatement(query$iv);
                Throwable throwable2 = null;
                try {
                    PreparedStatement ps = (PreparedStatement)autoCloseable2;
                    boolean bl2 = false;
                    Object object = ((Iterable)keys).iterator();
                    int n3 = 0;
                    while (object.hasNext()) {
                        int i = n3++;
                        Object key = object.next();
                        ((KeyedDataHandler)this.getDataHandler()).getIdHandler().setSQL(new RawSimplePreparedStatement(i * columnCount + 1, this.getDatabaseType(), ps), key);
                    }
                    object = ps.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        ResultSet result = (ResultSet)object;
                        boolean bl3 = false;
                        while (result.next()) {
                            IdDataTypeHandler idDataTypeHandler = ((KeyedDataHandler)this.getDataHandler()).getIdHandler();
                            DatabaseType databaseType = this.getDatabaseType();
                            Intrinsics.checkNotNull((Object)result);
                            Object key = idDataTypeHandler.fromSQL(new SimpleResultSetQuery(databaseType, result));
                            SQLDataGetterProvider provider = new SQLDataGetterProvider(this.getDatabaseType(), this.getTable(), null, false, false, new SimpleResultSetQuery(this.getDatabaseType(), result));
                            KeyedKingdomsObject data = (KeyedKingdomsObject)((KeyedDataHandler)this.getDataHandler()).load(provider, key);
                            handler.accept(data);
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable3);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit3 = unit;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String query = "DELETE FROM `" + this.getTable() + "` WHERE " + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getWhereClause();
        SQLDatabase this_$iv = this;
        boolean $i$f$prepareStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                boolean bl;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl2 = false;
                AutoCloseable autoCloseable2 = connection$iv.prepareStatement(query$iv);
                Throwable throwable2 = null;
                try {
                    PreparedStatement ps = (PreparedStatement)autoCloseable2;
                    boolean bl3 = false;
                    ((KeyedDataHandler)this.getDataHandler()).getIdHandler().setSQL(new RawSimplePreparedStatement(this.getDatabaseType(), ps), key);
                    bl = ps.execute();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                boolean bl4 = bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasData(@NotNull K key) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String query = "SELECT 1 FROM `" + this.getTable() + "` WHERE " + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getWhereClause();
        SQLDatabase this_$iv = this;
        boolean $i$f$prepareStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                boolean bl2;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl3 = false;
                AutoCloseable autoCloseable2 = connection$iv.prepareStatement(query$iv);
                Throwable throwable2 = null;
                try {
                    PreparedStatement ps = (PreparedStatement)autoCloseable2;
                    boolean bl4 = false;
                    ((KeyedDataHandler)this.getDataHandler()).getIdHandler().setSQL(new RawSimplePreparedStatement(this.getDatabaseType(), ps), key);
                    ResultSet result = ps.executeQuery();
                    bl2 = result.next();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                boolean bl5 = bl2;
                bl = bl5;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        int n;
        String query = "SELECT COUNT(*) FROM `" + this.getTable() + '`';
        SQLDatabase this_$iv = this;
        boolean $i$f$executeStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                int n2;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection$iv.createStatement();
                Throwable throwable2 = null;
                try {
                    int n3;
                    Statement ps$iv = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable3 = ps$iv.executeQuery(query$iv);
                    Throwable throwable3 = null;
                    try {
                        ResultSet result = (ResultSet)autoCloseable3;
                        boolean bl3 = false;
                        if (!result.next()) {
                            throw new AssertionError((Object)("Couldn't retrieve database size: '" + query + "' -> " + result));
                        }
                        n3 = result.getInt(1);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                    }
                    n2 = n3;
                }
                catch (Throwable throwable5) {
                    try {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                int n4 = n2;
                n = n4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<K> getAllDataKeys() {
        List keys = new ArrayList(this.totalDataCount);
        String query = "SELECT " + ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getColumnsTuple() + " FROM `" + this.getTable() + '`';
        SQLDatabase this_$iv = this;
        boolean $i$f$executeStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                Unit unit;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection$iv.createStatement();
                Throwable throwable2 = null;
                try {
                    Unit unit2;
                    Statement ps$iv = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable3 = ps$iv.executeQuery(query$iv);
                    Throwable throwable3 = null;
                    try {
                        ResultSet result = (ResultSet)autoCloseable3;
                        boolean bl3 = false;
                        while (result.next()) {
                            Object key = ((KeyedDataHandler)this.getDataHandler()).getIdHandler().fromSQL(new SimpleResultSetQuery(this.getDatabaseType(), result));
                            keys.add(key);
                        }
                        unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                    }
                    unit = unit2;
                }
                catch (Throwable throwable5) {
                    try {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                Unit unit3 = unit;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
        this.totalDataCount = (int)Math.max((double)this.totalDataCount, (double)keys.size());
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<T> loadAllData(@Nullable Predicate<K> filter) {
        List list = new ArrayList(this.totalDataCount);
        String query = "SELECT * FROM `" + this.getTable() + '`';
        SQLDatabase this_$iv = this;
        boolean $i$f$prepareStatement = false;
        String query$iv = SQLDatabase.access$handleQuery(this_$iv, query);
        try {
            AutoCloseable autoCloseable = SQLDatabase.access$getConnection(this_$iv);
            Throwable throwable = null;
            try {
                Unit unit;
                Connection connection$iv = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection$iv.prepareStatement(query$iv);
                Throwable throwable2 = null;
                try {
                    PreparedStatement ps = (PreparedStatement)autoCloseable2;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable3 = ps.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        ResultSet rs = (ResultSet)autoCloseable3;
                        boolean bl3 = false;
                        while (rs.next()) {
                            DatabaseType databaseType = this.getDatabaseType();
                            Intrinsics.checkNotNull((Object)rs);
                            SimpleResultSetQuery result = new SimpleResultSetQuery(databaseType, rs);
                            Object key = ((KeyedDataHandler)this.getDataHandler()).getIdHandler().fromSQL(result);
                            if (filter != null && !filter.test(key)) continue;
                            try {
                                SQLDataGetterProvider provider = new SQLDataGetterProvider(this.getDatabaseType(), this.getTable(), null, false, false, result);
                                list.add(((KeyedDataHandler)this.getDataHandler()).load(provider, key));
                            }
                            catch (Throwable ex) {
                                KLogger.error("Error while loading '" + key + "' of type " + this.getDataHandler().getClass().getSimpleName() + " in table '" + this.getTable() + "' (Skipping):");
                                ex.printStackTrace();
                            }
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                Unit unit3 = unit;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex$iv) {
            throw new RuntimeException("Error while handling data with query: " + query$iv + " with " + SQLDatabase.access$getConnectionProvider(this_$iv).getMetaString(), ex$iv);
        }
        this.totalDataCount = (int)Math.max((double)this.totalDataCount, (double)list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull Collection<? extends T> datas) {
        Intrinsics.checkNotNullParameter(datas, (String)"datas");
        if (datas.isEmpty()) {
            return;
        }
        PreparedNamedSetterStatement ps = new PreparedNamedSetterStatement(this.getDatabaseType(), this.getDataHandler().getSqlProperties().getAssociateNamedData());
        try {
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                connection.setAutoCommit(false);
                for (KeyedKingdomsObject data : datas) {
                    SQLDataSetterProvider provider = new SQLDataSetterProvider(this.getDatabaseType(), this.getTable(), null, false, false, ps);
                    IdDataTypeHandler idDataTypeHandler = ((KeyedDataHandler)this.getDataHandler()).getIdHandler();
                    SimplePreparedStatement simplePreparedStatement = ps;
                    Object k = data.getKey();
                    Intrinsics.checkNotNullExpressionValue(k, (String)"getKey(...)");
                    idDataTypeHandler.setSQL(simplePreparedStatement, k);
                    this.getDataHandler().save(provider, data);
                    ps.buildStatement(this.getTable(), connection);
                    ps.addBatch();
                }
                ps.execute();
                connection.commit();
                connection.setAutoCommit(true);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while trying to save batch data with " + this.getConnectionProvider().getMetaString(), e);
        }
    }
}

