/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.DynamicSection;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StringMappedIdSetter;
import org.kingdoms.data.database.flatfile.json.JsonElementDataProvider;
import org.kingdoms.data.database.flatfile.json.JsonObjectDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataProvider;
import org.kingdoms.data.database.sql.SQLDataProviderKt;
import org.kingdoms.data.database.sql.statements.setters.PreparedNamedSetterStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u00015B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tH\u0016J0\u0010#\u001a\u00020\u0010\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u0002H$0(H\u0016J<\u0010*\u001a\u00020\u0010\"\u0004\b\u0000\u0010+\"\u0004\b\u0001\u0010$2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u0002H$0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u0002H$0/H\u0016J\u0010\u00100\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u00103\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u000104H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/kingdoms/data/database/sql/SQLDataSetterProvider;", "Lorg/kingdoms/data/database/sql/SQLDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "table", "", "name", "isInsideSingularEntity", "", "nameIsSection", "statement", "Lorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Ljava/lang/String;ZZLorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;)V", "checkNullName", "", "get", "setString", "value", "setInt", "", "setLocation", "Lorg/bukkit/Location;", "setSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "setSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "setLong", "", "setFloat", "", "setDouble", "", "setBoolean", "setCollection", "V", "collection", "", "elementHandler", "Ljava/util/function/BiConsumer;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "setMap", "K", "map", "", "handler", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "createSection", "createDynamicSection", "Lorg/kingdoms/data/database/dataprovider/DynamicSection;", "setUUID", "Ljava/util/UUID;", "SQLDynamicSection", "core"})
public final class SQLDataSetterProvider
extends SQLDataProvider
implements SectionableDataSetter {
    @NotNull
    private final PreparedNamedSetterStatement statement;

    public SQLDataSetterProvider(@NotNull DatabaseType databaseType, @NotNull String table, @Nullable String name, boolean isInsideSingularEntity, boolean nameIsSection, @NotNull PreparedNamedSetterStatement statement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super(databaseType, table, name, isInsideSingularEntity, nameIsSection);
        this.statement = statement;
    }

    private final void checkNullName() {
        if (this.getName$core() != null && !this.getNameIsSection$core()) {
            throw new IllegalStateException("Specified name is not given a type: " + this.getTable$core() + " -> " + this.getName$core());
        }
    }

    @Override
    @NotNull
    public SectionableDataSetter get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkNullName();
        return new SQLDataSetterProvider(this.getDatabaseType$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, this.isInsideSingularEntity$core(), false, this.statement);
    }

    @Override
    public void setString(@Nullable String value) {
        this.statement.setString(this.getNamed$core(), value);
    }

    @Override
    public void setInt(int value) {
        this.statement.setInt(this.getNamed$core(), value);
    }

    @Override
    public void setLocation(@Nullable Location value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        if (value == null) {
            return;
        }
        PreparedNamedSetterStatement $this$setLocation_u24lambda_u240 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        String string = this.getNamed$core() + "_world";
        World world = value.getWorld();
        Intrinsics.checkNotNull((Object)world);
        $this$setLocation_u24lambda_u240.setString(string, world.getName());
        $this$setLocation_u24lambda_u240.setDouble(this.getNamed$core() + "_x", value.getX());
        $this$setLocation_u24lambda_u240.setDouble(this.getNamed$core() + "_y", value.getY());
        $this$setLocation_u24lambda_u240.setDouble(this.getNamed$core() + "_z", value.getZ());
        $this$setLocation_u24lambda_u240.setFloat(this.getNamed$core() + "_yaw", value.getYaw());
        $this$setLocation_u24lambda_u240.setFloat(this.getNamed$core() + "_pitch", value.getPitch());
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        if (value == null) {
            return;
        }
        PreparedNamedSetterStatement $this$setSimpleLocation_u24lambda_u241 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        $this$setSimpleLocation_u24lambda_u241.setString(this.getNamed$core() + "_world", value.getWorld());
        $this$setSimpleLocation_u24lambda_u241.setInt(this.getNamed$core() + "_x", value.getX());
        $this$setSimpleLocation_u24lambda_u241.setInt(this.getNamed$core() + "_y", value.getY());
        $this$setSimpleLocation_u24lambda_u241.setInt(this.getNamed$core() + "_z", value.getZ());
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PreparedNamedSetterStatement $this$setSimpleChunkLocation_u24lambda_u242 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        $this$setSimpleChunkLocation_u24lambda_u242.setString(this.getNamed$core() + "_world", value.getWorld());
        $this$setSimpleChunkLocation_u24lambda_u242.setInt(this.getNamed$core() + "_x", value.getX());
        $this$setSimpleChunkLocation_u24lambda_u242.setInt(this.getNamed$core() + "_z", value.getZ());
    }

    @Override
    public void setLong(long value) {
        this.statement.setLong(this.getNamed$core(), value);
    }

    @Override
    public void setFloat(float value) {
        this.statement.setFloat(this.getNamed$core(), value);
    }

    @Override
    public void setDouble(double value) {
        this.statement.setDouble(this.getNamed$core(), value);
    }

    @Override
    public void setBoolean(boolean value) {
        this.statement.setBoolean(this.getNamed$core(), value);
    }

    @Override
    public <V> void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        if (collection.isEmpty()) {
            this.statement.addParameterIfNotExist(this.getNamed$core());
            this.statement.setJson(this.getNamed$core(), (JsonElement)SQLDataProviderKt.access$getEMPTY_JSON_ARRAY$p());
            return;
        }
        JsonArray array = new JsonArray();
        JsonElementDataProvider arrayProvider = new JsonElementDataProvider((JsonElement)array);
        for (V element : collection) {
            elementHandler.accept(arrayProvider, element);
        }
        this.statement.setJson(this.getNamed$core(), (JsonElement)array);
    }

    @Override
    public <K, V> void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (map.isEmpty()) {
            this.statement.addParameterIfNotExist(this.getNamed$core());
            this.statement.setJson(this.getNamed$core(), (JsonElement)SQLDataProviderKt.access$getEMPTY_JSON_OBJECT$p());
            return;
        }
        JsonObject obj = new JsonObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            handler.map(key, new StringMappedIdSetter((Function1<? super String, ? extends SectionCreatableDataSetter>)((Function1)arg_0 -> SQLDataSetterProvider.setMap$lambda$3(obj, arg_0))), value);
        }
        this.statement.setJson(this.getNamed$core(), (JsonElement)obj);
    }

    @Override
    @NotNull
    public SectionableDataSetter createSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkNullName();
        return new SQLDataSetterProvider(this.getDatabaseType$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, this.isInsideSingularEntity$core(), true, this.statement);
    }

    @Override
    @NotNull
    public DynamicSection createDynamicSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SQLDynamicSection(name, new JsonObjectDataProvider(null, new JsonObject()));
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        this.statement.setUUID(this.getNamed$core(), value);
    }

    private static final SectionCreatableDataSetter setMap$lambda$3(JsonObject $obj, String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new JsonObjectDataProvider(id, $obj);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/kingdoms/data/database/sql/SQLDataSetterProvider$SQLDynamicSection;", "Lorg/kingdoms/data/database/dataprovider/DynamicSection;", "name", "", "setter", "Lorg/kingdoms/data/database/flatfile/json/JsonObjectDataProvider;", "<init>", "(Lorg/kingdoms/data/database/sql/SQLDataSetterProvider;Ljava/lang/String;Lorg/kingdoms/data/database/flatfile/json/JsonObjectDataProvider;)V", "getSetter", "()Lorg/kingdoms/data/database/flatfile/json/JsonObjectDataProvider;", "close", "", "core"})
    public final class SQLDynamicSection
    implements DynamicSection {
        @NotNull
        private final String name;
        @NotNull
        private final JsonObjectDataProvider setter;

        public SQLDynamicSection(@NotNull String name, JsonObjectDataProvider setter) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)setter, (String)"setter");
            this.name = name;
            this.setter = setter;
        }

        @Override
        @NotNull
        public JsonObjectDataProvider getSetter() {
            return this.setter;
        }

        @Override
        public void close() {
            SQLDataSetterProvider.this.statement.setJson(this.name, (JsonElement)this.getSetter().getObj());
        }
    }
}

