/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.statements.SQLBackup;
import org.kingdoms.data.database.sql.statements.SQLColumnAdd;
import org.kingdoms.data.database.sql.statements.SQLColumnModify;
import org.kingdoms.data.database.sql.statements.SQLColumnRemove;
import org.kingdoms.data.database.sql.statements.SQLColumnRename;
import org.kingdoms.data.database.sql.statements.SQLRestore;
import org.kingdoms.data.database.sql.statements.SQLStatement;
import org.kingdoms.data.database.sql.statements.SQLUpsert;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.libs.hikari.HikariConfig;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.libs.kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001.BA\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H&J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH&J\u0018\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006/"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType;", "", "defaultPort", "", "dependencies", "", "Lorg/kingdoms/dependencies/Dependency;", "dataSourceClassName", "", "driverClassName", "driverJdbcIdentifier", "systemIdentifierEscapeChar", "", "<init>", "(Ljava/lang/String;II[Lorg/kingdoms/dependencies/Dependency;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;C)V", "getDefaultPort", "()I", "getDependencies", "()[Lorg/kingdoms/dependencies/Dependency;", "[Lorg/kingdoms/dependencies/Dependency;", "getDataSourceClassName", "()Ljava/lang/String;", "getDriverClassName", "getDriverJdbcIdentifier", "getSystemIdentifierEscapeChar", "()C", "SQLite", "H2", "MariaDB", "MySQL", "PostgreSQL", "JSON", "YAML", "MongoDB", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "Companion", "core"})
public abstract class DatabaseType
extends Enum<DatabaseType> {
    @NotNull
    public static final Companion Companion;
    private final int defaultPort;
    @NotNull
    private final Dependency[] dependencies;
    @NotNull
    private final String dataSourceClassName;
    @NotNull
    private final String driverClassName;
    @NotNull
    private final String driverJdbcIdentifier;
    private final char systemIdentifierEscapeChar;
    @NotNull
    private static final Regex SQLITE_TEXT_AFFINITY;
    @NotNull
    private static final Regex SQLITE_BLOB_AFFINITY;
    public static final /* enum */ DatabaseType SQLite;
    public static final /* enum */ DatabaseType H2;
    public static final /* enum */ DatabaseType MariaDB;
    public static final /* enum */ DatabaseType MySQL;
    public static final /* enum */ DatabaseType PostgreSQL;
    public static final /* enum */ DatabaseType JSON;
    public static final /* enum */ DatabaseType YAML;
    public static final /* enum */ DatabaseType MongoDB;
    private static final /* synthetic */ DatabaseType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DatabaseType(int defaultPort, Dependency[] dependencies, String dataSourceClassName, String driverClassName, String driverJdbcIdentifier, char systemIdentifierEscapeChar) {
        this.defaultPort = defaultPort;
        this.dependencies = dependencies;
        this.dataSourceClassName = dataSourceClassName;
        this.driverClassName = driverClassName;
        this.driverJdbcIdentifier = driverJdbcIdentifier;
        this.systemIdentifierEscapeChar = systemIdentifierEscapeChar;
    }

    /* synthetic */ DatabaseType(String string, int n, int n2, Dependency[] dependencyArray, String string2, String string3, String string4, char c, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            c = (char)96;
        }
        this(n2, dependencyArray, string2, string3, string4, c);
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public final Dependency[] getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @NotNull
    public final String getDriverClassName() {
        return this.driverClassName;
    }

    @NotNull
    public final String getDriverJdbcIdentifier() {
        return this.driverJdbcIdentifier;
    }

    public final char getSystemIdentifierEscapeChar() {
        return this.systemIdentifierEscapeChar;
    }

    public abstract void applyProperties(@NotNull HikariConfig var1, @NotNull DatabaseProperties var2);

    @NotNull
    public abstract String processCommands(@NotNull String var1);

    @NotNull
    public abstract String createStatement(@NotNull SQLStatement var1, @NotNull String var2);

    public static DatabaseType[] values() {
        return (DatabaseType[])$VALUES.clone();
    }

    public static DatabaseType valueOf(String value) {
        return Enum.valueOf(DatabaseType.class, value);
    }

    @NotNull
    public static EnumEntries<DatabaseType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ DatabaseType(String $enum$name, int $enum$ordinal, int defaultPort, Dependency[] dependencies, String dataSourceClassName, String driverClassName, String driverJdbcIdentifier, char systemIdentifierEscapeChar, DefaultConstructorMarker $constructor_marker) {
        this(defaultPort, dependencies, dataSourceClassName, driverClassName, driverJdbcIdentifier, systemIdentifierEscapeChar);
    }

    static {
        SQLite = new SQLite("SQLite", 0);
        H2 = new H2("H2", 1);
        MariaDB = new MariaDB("MariaDB", 2);
        MySQL = new MySQL("MySQL", 3);
        PostgreSQL = new PostgreSQL("PostgreSQL", 4);
        JSON = new JSON("JSON", 5);
        YAML = new YAML("YAML", 6);
        MongoDB = new MongoDB("MongoDB", 7);
        $VALUES = databaseTypeArray = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2, DatabaseType.MariaDB, DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.JSON, DatabaseType.YAML, DatabaseType.MongoDB};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(N)?(VAR)?CHAR\\(\\d+\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern pattern2 = pattern;
        SQLITE_TEXT_AFFINITY = new Regex(pattern2);
        Pattern pattern3 = Pattern.compile("BINARY\\(\\d+\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        pattern2 = pattern3;
        SQLITE_BLOB_AFFINITY = new Regex(pattern2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$Companion;", "", "<init>", "()V", "SQLITE_TEXT_AFFINITY", "Lorg/kingdoms/libs/kotlin/text/Regex;", "SQLITE_BLOB_AFFINITY", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.H2", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "createStatement", "", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "processCommands", "line", "core"})
    static final class H2
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        H2() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.H2_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SQLStatement sQLStatement = info;
            if (sQLStatement instanceof SQLUpsert) {
                string = "MERGE INTO `" + table + "` (" + ((SQLUpsert)info).getParameters() + ") VALUES(" + ((SQLUpsert)info).getPreparedValues() + ')';
            } else if (sQLStatement instanceof SQLColumnRemove) {
                string = "ALTER TABLE `" + table + "` DROP COLUMN " + ((SQLColumnRemove)info).getColumnName();
            } else if (sQLStatement instanceof SQLColumnAdd) {
                String defaultVal = ((SQLColumnAdd)info).getDefaultValue() == null ? "" : " DEFAULT '" + ((SQLColumnAdd)info).getDefaultValue() + '\'';
                string = "ALTER TABLE `" + table + "` ADD " + this.processCommands(((SQLColumnAdd)info).getColumn().getName()) + ' ' + ((SQLColumnAdd)info).getColumn().getType() + ' ' + ((SQLColumnAdd)info).getColumn().getNullability() + defaultVal;
            } else if (sQLStatement instanceof SQLColumnRename) {
                string = "ALTER TABLE `" + table + "` ALTER COLUMN " + ((SQLColumnRename)info).getColumnName() + " RENAME TO " + ((SQLColumnRename)info).getNewColumnName();
            } else if (sQLStatement instanceof SQLColumnModify) {
                string = "ALTER TABLE `" + table + "` ALTER COLUMN " + ((SQLColumnModify)info).getColumnName() + ' ' + ((SQLColumnModify)info).getColumn().getType() + ' ' + ((SQLColumnModify)info).getColumn().getNullability();
            } else if (sQLStatement instanceof SQLBackup) {
                string = "SCRIPT TO '" + ((SQLBackup)info).getTo().resolve(((SQLBackup)info).getNamed() + ".sql").toAbsolutePath() + '\'';
            } else if (sQLStatement instanceof SQLRestore) {
                string = "RUNSCRIPT FROM '" + ((SQLRestore)info).getFrom().toAbsolutePath() + '\'';
            } else {
                throw new UnsupportedOperationException(info.toString());
            }
            return string;
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"LONG", (String)"BIGINT", (boolean)false), (String)"FLOAT", (String)"REAL", (boolean)false), (String)"DOUBLE", (String)"DOUBLE PRECISION", (boolean)false), (String)"NVARCHAR", (String)"VARCHAR", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.JSON", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "core"})
    static final class JSON
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        JSON() {
            void var1_1;
        }

        @NotNull
        public Void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.MariaDB", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "createStatement", "", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "processCommands", "line", "core"})
    @SourceDebugExtension(value={"SMAP\nDatabaseType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseType.kt\norg/kingdoms/data/database/sql/DatabaseType$MariaDB\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,315:1\n126#2:316\n153#2,3:317\n*S KotlinDebug\n*F\n+ 1 DatabaseType.kt\norg/kingdoms/data/database/sql/DatabaseType$MariaDB\n*L\n131#1:316\n131#1:317,3\n*E\n"})
    static final class MariaDB
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MariaDB() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.MARIADB_DRIVER};
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            String string;
            DatabaseProperties databaseProperties2;
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            DatabaseProperties $this$applyProperties_u24lambda_u241 = databaseProperties2 = databaseProperties;
            boolean bl = false;
            if ($this$applyProperties_u24lambda_u241.getOthers().isEmpty()) {
                void $this$mapTo$iv$iv;
                char c = '?';
                Map<String, Object> $this$map$iv = $this$applyProperties_u24lambda_u241.getOthers();
                boolean $i$f$map = false;
                Map<String, Object> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void e;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((String)e.getKey() + '=' + e.getValue());
                }
                String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
                string = c + string2;
            } else {
                string = "";
            }
            String propertiesString = string;
            hikariConfig.addDataSourceProperty("url", (Object)("jdbc:mariadb://" + $this$applyProperties_u24lambda_u241.getAddress() + ':' + $this$applyProperties_u24lambda_u241.getPort() + '/' + $this$applyProperties_u24lambda_u241.getDatabaseName() + propertiesString));
            hikariConfig.addDataSourceProperty("user", (Object)$this$applyProperties_u24lambda_u241.getUser());
            hikariConfig.addDataSourceProperty("password", (Object)$this$applyProperties_u24lambda_u241.getPassword());
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SQLStatement sQLStatement = info;
            if (sQLStatement instanceof SQLUpsert) {
                string = "REPLACE INTO " + table + " (" + ((SQLUpsert)info).getParameters() + ") VALUES(" + ((SQLUpsert)info).getPreparedValues() + ')';
            } else if (sQLStatement instanceof SQLColumnRemove) {
                string = "ALTER TABLE " + table + " DROP COLUMN " + ((SQLColumnRemove)info).getColumnName();
            } else if (sQLStatement instanceof SQLColumnAdd) {
                string = "ALTER TABLE " + table + " ADD " + this.processCommands(((SQLColumnAdd)info).getColumn().getName()) + ' ' + ((SQLColumnAdd)info).getColumn().getType() + ' ' + (((SQLColumnAdd)info).getColumn().getNullable() ? "NULL" : "NOT NULL");
            } else if (sQLStatement instanceof SQLColumnRename) {
                string = "ALTER TABLE " + table + " ALTER COLUMN " + ((SQLColumnRename)info).getColumnName() + " RENAME TO " + ((SQLColumnRename)info).getNewColumnName();
            } else {
                throw new UnsupportedOperationException(info.toString());
            }
            return string;
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"UUID", (String)"BINARY(16)", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.MongoDB", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "core"})
    static final class MongoDB
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MongoDB() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.SLF4J_SIMPLE, Dependency.MONGODB_DRIVER_SYNC, Dependency.MONGODB_DRIVER_BSON, Dependency.MONGODB_DRIVER_CORE};
        }

        @NotNull
        public Void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.MySQL", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "core"})
    static final class MySQL
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MySQL() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.MYSQL_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            DatabaseProperties databaseProperties2;
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            DatabaseProperties $this$applyProperties_u24lambda_u240 = databaseProperties2 = databaseProperties;
            boolean bl = false;
            $this$applyProperties_u24lambda_u240.add("cachePrepStmts", true);
            $this$applyProperties_u24lambda_u240.add("prepStmtCacheSize", 250);
            $this$applyProperties_u24lambda_u240.add("prepStmtCacheSqlLimit", 2048);
            $this$applyProperties_u24lambda_u240.add("useServerPrepStmts", true);
            $this$applyProperties_u24lambda_u240.add("useLocalSessionState", true);
            $this$applyProperties_u24lambda_u240.add("rewriteBatchedStatements", true);
            $this$applyProperties_u24lambda_u240.add("cacheResultSetMetadata", true);
            $this$applyProperties_u24lambda_u240.add("cacheServerConfiguration", true);
            $this$applyProperties_u24lambda_u240.add("elideSetAutoCommits", true);
            $this$applyProperties_u24lambda_u240.add("maintainTimeStats", false);
            String[] stringArray = new String[]{"useUnicode", "characterEncoding"};
            $this$applyProperties_u24lambda_u240.ignore(stringArray);
            databaseProperties.useStandardDataSourcePropertyAppendar(hikariConfig);
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"UUID", (String)"BINARY(16)", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SQLStatement sQLStatement = info;
            if (sQLStatement instanceof SQLUpsert) {
                string = "REPLACE INTO `" + table + "` (" + ((SQLUpsert)info).getParameters() + ") VALUES(" + ((SQLUpsert)info).getPreparedValues() + ')';
            } else if (sQLStatement instanceof SQLColumnRemove) {
                string = "ALTER TABLE `" + table + "` DROP COLUMN " + ((SQLColumnRemove)info).getColumnName();
            } else if (sQLStatement instanceof SQLColumnAdd) {
                string = "ALTER TABLE `" + table + "` ADD " + this.processCommands(((SQLColumnAdd)info).getColumn().getName()) + ' ' + ((SQLColumnAdd)info).getColumn().getType() + ' ' + (((SQLColumnAdd)info).getColumn().getNullable() ? "NULL" : "NOT NULL");
            } else if (sQLStatement instanceof SQLColumnRename) {
                string = "ALTER TABLE `" + table + "` ALTER COLUMN " + ((SQLColumnRename)info).getColumnName() + " RENAME TO " + ((SQLColumnRename)info).getNewColumnName();
            } else {
                throw new UnsupportedOperationException(info.toString());
            }
            return string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.PostgreSQL", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "core"})
    @SourceDebugExtension(value={"SMAP\nDatabaseType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseType.kt\norg/kingdoms/data/database/sql/DatabaseType$PostgreSQL\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1557#2:316\n1628#2,3:317\n*S KotlinDebug\n*F\n+ 1 DatabaseType.kt\norg/kingdoms/data/database/sql/DatabaseType$PostgreSQL\n*L\n251#1:316\n251#1:317,3\n*E\n"})
    static final class PostgreSQL
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        PostgreSQL() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.POSTGRESQL_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            String[] stringArray = new String[]{"verifyServerCertificate", "allowPublicKeyRetrieval", "useSSL", "useUnicode", "characterEncoding", "port"};
            databaseProperties.ignore(stringArray);
            databaseProperties.useStandardDataSourcePropertyAppendar(hikariConfig);
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"NVARCHAR", (String)"VARCHAR", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"DOUBLE", (String)"DOUBLE PRECISION", (boolean)false), (String)"STRICT", (String)"", (boolean)false), (char)'`', (char)'\"', (boolean)false, (int)4, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SQLStatement sQLStatement = info;
            if (sQLStatement instanceof SQLUpsert) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String columnNames = StringsKt.replace$default((String)((SQLUpsert)info).getParameters(), (char)'`', (char)this.getSystemIdentifierEscapeChar(), (boolean)false, (int)4, null);
                Object object = new String[]{","};
                object = StringsKt.split$default((CharSequence)columnNames, (String[])object, (boolean)false, (int)0, (int)6, null);
                StringBuilder stringBuilder = new StringBuilder().append("INSERT INTO \"").append(table).append("\" (").append(columnNames).append(") VALUES(").append(((SQLUpsert)info).getPreparedValues()).append(") ON CONFLICT ON CONSTRAINT \"").append(table).append("_pkey\" DO UPDATE SET (").append(columnNames).append(") = (");
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)x))).toString());
                }
                string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, PostgreSQL::createStatement$lambda$1, (int)30, null)).append(')').toString();
            } else if (sQLStatement instanceof SQLColumnRemove) {
                string = "ALTER TABLE `" + table + "` DROP COLUMN " + ((SQLColumnRemove)info).getColumnName();
            } else if (sQLStatement instanceof SQLColumnAdd) {
                String defaultVal = ((SQLColumnAdd)info).getDefaultValue() == null ? "" : " DEFAULT '" + ((SQLColumnAdd)info).getDefaultValue() + '\'';
                string = "ALTER TABLE `" + table + "` ADD COLUMN " + this.processCommands(((SQLColumnAdd)info).getColumn().getName()) + ' ' + ((SQLColumnAdd)info).getColumn().getType() + ' ' + (((SQLColumnAdd)info).getColumn().getNullable() ? "NULL" : "NOT NULL") + defaultVal;
            } else if (sQLStatement instanceof SQLColumnRename) {
                string = "ALTER TABLE `" + table + "` RENAME COLUMN " + ((SQLColumnRename)info).getColumnName() + " TO " + ((SQLColumnRename)info).getNewColumnName();
            } else {
                throw new UnsupportedOperationException(info.toString());
            }
            return string;
        }

        private static final CharSequence createStatement$lambda$1(String x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return "excluded." + x;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.SQLite", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "createStatement", "", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "processCommands", "line", "core"})
    static final class SQLite
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        SQLite() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.SQLITE_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            SQLStatement sQLStatement = info;
            if (sQLStatement instanceof SQLUpsert) {
                string = "INSERT OR REPLACE INTO `" + table + "` (" + ((SQLUpsert)info).getParameters() + ") VALUES(" + ((SQLUpsert)info).getPreparedValues() + ')';
            } else if (sQLStatement instanceof SQLColumnRemove) {
                string = "ALTER TABLE `" + table + "` DROP COLUMN " + ((SQLColumnRemove)info).getColumnName();
            } else if (sQLStatement instanceof SQLColumnAdd) {
                string = "ALTER TABLE `" + table + "` ADD COLUMN " + this.processCommands(((SQLColumnAdd)info).getColumn().getName()) + ' ' + ((SQLColumnAdd)info).getColumn().getType() + ' ' + (((SQLColumnAdd)info).getColumn().getNullable() ? "NULL" : "NOT NULL");
            } else if (sQLStatement instanceof SQLColumnRename) {
                string = "ALTER TABLE `" + table + "` RENAME COLUMN " + ((SQLColumnRename)info).getColumnName() + " TO " + ((SQLColumnRename)info).getNewColumnName();
            } else {
                throw new UnsupportedOperationException(info.toString());
            }
            return string;
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence charSequence = StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"LONG", (String)"INT", (boolean)false), (String)"UUID", (String)"BLOB", (boolean)false), (String)"FLOAT", (String)"REAL", (boolean)false), (String)"DOUBLE", (String)"REAL", (boolean)false), (String)"BIGINT", (String)"INT", (boolean)false), (String)"BOOL", (String)"INT", (boolean)false), (String)"JSON", (String)"TEXT", (boolean)false);
            Regex regex = SQLITE_BLOB_AFFINITY;
            String string = "BLOB";
            charSequence = regex.replace(charSequence, string);
            regex = SQLITE_TEXT_AFFINITY;
            string = "TEXT";
            return regex.replace(charSequence, string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"org/kingdoms/data/database/sql/DatabaseType.YAML", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "createStatement", "info", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "table", "core"})
    static final class YAML
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        YAML() {
            void var1_1;
        }

        @NotNull
        public Void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String createStatement(@NotNull SQLStatement info, @NotNull String table) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            throw new UnsupportedOperationException();
        }
    }
}

