/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.mongo;

import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.base.SingularKingdomsDatabase;
import org.kingdoms.data.database.mongo.MongoDBDatabase;
import org.kingdoms.data.database.mongo.MongoDataProvider;
import org.kingdoms.data.database.mongo.SingularMongoIdQueryContainer;
import org.kingdoms.data.handlers.abstraction.SingularDataHandler;
import org.kingdoms.libs.bson.Document;
import org.kingdoms.libs.bson.conversions.Bson;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.mongodb.client.MongoCollection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u001aB%\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000f\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/kingdoms/data/database/mongo/SingularMongoDBDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "Lorg/kingdoms/data/database/mongo/MongoDBDatabase;", "Lorg/kingdoms/data/database/base/SingularKingdomsDatabase;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "collection", "Lorg/kingdoms/libs/mongodb/client/MongoCollection;", "Lorg/kingdoms/libs/bson/Document;", "<init>", "(Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;Lcom/mongodb/client/MongoCollection;)V", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "createDocument", "constructIdContainer", "Lorg/kingdoms/data/database/mongo/SingularMongoIdQueryContainer;", "deleteAllData", "", "save", "data", "(Lorg/kingdoms/constants/base/KingdomsObject;)V", "load", "()Lorg/kingdoms/constants/base/KingdomsObject;", "hasData", "", "Companion", "core"})
public final class SingularMongoDBDatabase<T extends KingdomsObject>
extends MongoDBDatabase<T>
implements SingularKingdomsDatabase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingularDataHandler<T> dataHandler;

    private SingularMongoDBDatabase(SingularDataHandler<T> dataHandler, MongoCollection<Document> collection) {
        super(collection);
        this.dataHandler = dataHandler;
    }

    @Override
    @NotNull
    protected SingularDataHandler<T> getDataHandler() {
        return this.dataHandler;
    }

    private final Document createDocument() {
        return new Document("_id", null);
    }

    private final SingularMongoIdQueryContainer constructIdContainer() {
        return new SingularMongoIdQueryContainer();
    }

    @Override
    public void deleteAllData() {
        this.getCollection().deleteOne((Bson)this.constructIdContainer());
    }

    @Override
    public void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Document document = this.createDocument();
        MongoDataProvider provider = new MongoDataProvider(null, document);
        this.getDataHandler().save(provider, data);
        this.getCollection().replaceOne((Bson)this.constructIdContainer(), (Object)document, MongoDBDatabase.Companion.getUPSERT$core());
    }

    @Override
    @Nullable
    public T load() {
        Document document = (Document)this.getCollection().find((Bson)this.constructIdContainer()).first();
        if (document == null) {
            return null;
        }
        Document doc = document;
        MongoDataProvider provider = new MongoDataProvider(null, doc);
        return (T)((KingdomsObject)((SingularDataHandler)this.getDataHandler()).load(provider));
    }

    @Override
    public boolean hasData() {
        return this.getCollection().find((Bson)this.constructIdContainer()).first() != null;
    }

    @JvmStatic
    @NotNull
    public static final <T extends KingdomsObject> SingularMongoDBDatabase<T> withCollection(@NotNull String name, @NotNull SingularDataHandler<T> dataHandler) {
        return Companion.withCollection(name, dataHandler);
    }

    public /* synthetic */ SingularMongoDBDatabase(SingularDataHandler dataHandler, MongoCollection collection, DefaultConstructorMarker $constructor_marker) {
        this(dataHandler, (MongoCollection<Document>)collection);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/data/database/mongo/SingularMongoDBDatabase$Companion;", "", "<init>", "()V", "withCollection", "Lorg/kingdoms/data/database/mongo/SingularMongoDBDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "name", "", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T extends KingdomsObject> SingularMongoDBDatabase<T> withCollection(@NotNull String name, @NotNull SingularDataHandler<T> dataHandler) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
            return new SingularMongoDBDatabase(dataHandler, MongoDBDatabase.Companion.getCollection(name), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

