/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.yaml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Path;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.flatfile.KeyedFlatFileDatabase;
import org.kingdoms.data.database.flatfile.yaml.YamlDatabase;
import org.kingdoms.data.database.flatfile.yaml.YamlMappingDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/data/database/flatfile/yaml/KeyedYamlDatabase;", "K", "", "T", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "Lorg/kingdoms/data/database/flatfile/KeyedFlatFileDatabase;", "folder", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "<init>", "(Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;)V", "getDatabaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "load", "key", "reader", "Ljava/io/BufferedReader;", "(Ljava/lang/Object;Ljava/io/BufferedReader;)Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "save", "", "data", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/base/KeyedKingdomsObject;Ljava/io/BufferedWriter;)V", "core"})
public final class KeyedYamlDatabase<K, T extends KeyedKingdomsObject<K>>
extends KeyedFlatFileDatabase<K, T> {
    public KeyedYamlDatabase(@NotNull Path folder, @NotNull KeyedDataHandler<K, T> dataHandler) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        super("yml", folder, dataHandler);
    }

    @Override
    @NotNull
    public DatabaseType getDatabaseType() {
        return DatabaseType.YAML;
    }

    @Override
    @NotNull
    public T load(@NotNull K key, @NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        String stringKey = this.getDataHandler().getIdHandler().toString(key);
        YamlMappingDataProvider provider = YamlDatabase.load(stringKey, reader);
        return (T)((KeyedKingdomsObject)this.getDataHandler().load(provider, key));
    }

    @Override
    public void save(@NotNull T data, @NotNull BufferedWriter writer) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        YamlDatabase.save((KingdomsObject)data, this.getDataHandler(), writer);
    }
}

