/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.json;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Path;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.flatfile.SingularFlatFileDatabase;
import org.kingdoms.data.database.flatfile.json.JsonDatabase;
import org.kingdoms.data.database.flatfile.json.JsonObjectDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.handlers.abstraction.SingularDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/data/database/flatfile/json/SingularJsonDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "Lorg/kingdoms/data/database/flatfile/SingularFlatFileDatabase;", "file", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "<init>", "(Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;)V", "getDatabaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "load", "reader", "Ljava/io/BufferedReader;", "(Ljava/io/BufferedReader;)Lorg/kingdoms/constants/base/KingdomsObject;", "save", "", "data", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/base/KingdomsObject;Ljava/io/BufferedWriter;)V", "core"})
public final class SingularJsonDatabase<T extends KingdomsObject>
extends SingularFlatFileDatabase<T> {
    public SingularJsonDatabase(@NotNull Path file, @NotNull SingularDataHandler<T> dataHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        super(file, dataHandler);
    }

    @Override
    @NotNull
    public DatabaseType getDatabaseType() {
        return DatabaseType.JSON;
    }

    @Override
    @Nullable
    public T load(@NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return JsonDatabase.load(((Object)this.getFile().toAbsolutePath()).toString(), this.getFile(), this.getDataHandler(), reader, arg_0 -> SingularJsonDatabase.load$lambda$0(this, arg_0));
    }

    @Override
    public void save(@NotNull T data, @NotNull BufferedWriter writer) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JsonDatabase.save(data, this.getDataHandler(), writer);
    }

    private static final KingdomsObject load$lambda$0(SingularJsonDatabase this$0, JsonObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return (KingdomsObject)this$0.getDataHandler().load(new JsonObjectDataProvider(null, obj));
    }
}

