/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.json;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.flatfile.json.JsonObjectDataProvider;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.gson.KingdomsGson;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0015\u001a\u0002H\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00050\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/data/database/flatfile/json/JsonDatabase;", "", "<init>", "()V", "load", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "label", "", "path", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/DataHandler;", "reader", "Ljava/io/BufferedReader;", "loader", "Lorg/kingdoms/libs/kotlin/Function1;", "Lcom/google/gson/JsonObject;", "(Ljava/lang/String;Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/abstraction/DataHandler;Ljava/io/BufferedReader;Lkotlin/jvm/functions/Function1;)Lorg/kingdoms/constants/base/KingdomsObject;", "save", "", "data", "handler", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/base/KingdomsObject;Lorg/kingdoms/data/handlers/abstraction/DataHandler;Ljava/io/BufferedWriter;)V", "core"})
public final class JsonDatabase {
    @NotNull
    public static final JsonDatabase INSTANCE = new JsonDatabase();

    private JsonDatabase() {
    }

    @JvmStatic
    @Nullable
    public static final <T extends KingdomsObject> T load(@NotNull String label, @NotNull Path path, @NotNull DataHandler<T> dataHandler, @NotNull BufferedReader reader, @NotNull Function1<? super JsonObject, ? extends T> loader) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        try {
            JsonObject obj = KingdomsGson.parse(reader);
            Intrinsics.checkNotNull((Object)obj);
            KingdomsObject data = (KingdomsObject)loader.invoke((Object)obj);
            if (data == null) {
                KLogger.error("Could not load data for '" + label + "' with adapter " + dataHandler + " JSON:(" + Files.lines(path).collect(Collectors.joining()) + ") Deleting their data...");
                Files.delete(path);
                return null;
            }
            return (T)data;
        }
        catch (JsonSyntaxException ex) {
            try {
                String lines = Files.lines(path).collect(Collectors.joining());
                KLogger.error("Malformed JSON data '" + path.toAbsolutePath() + "' with adapter " + dataHandler + " JSON:(" + lines + ") Deleting their data...");
                if (lines.length() <= 2) {
                    Files.delete(path);
                }
                ex.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @JvmStatic
    public static final <T extends KingdomsObject> void save(@NotNull T data, @NotNull DataHandler<T> handler, @NotNull BufferedWriter writer) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JsonObject object = new JsonObject();
        JsonObjectDataProvider provider = new JsonObjectDataProvider(null, object);
        handler.save(provider, data);
        try {
            KingdomsGson.toJson(object, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

