/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.base.SingularKingdomsDatabase;
import org.kingdoms.data.handlers.abstraction.SingularDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.io.CloseableKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H&\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/data/database/flatfile/SingularFlatFileDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "Lorg/kingdoms/data/database/base/SingularKingdomsDatabase;", "file", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "<init>", "(Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;)V", "getFile", "()Ljava/nio/file/Path;", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/SingularDataHandler;", "load", "()Lorg/kingdoms/constants/base/KingdomsObject;", "reader", "Ljava/io/BufferedReader;", "(Ljava/io/BufferedReader;)Lorg/kingdoms/constants/base/KingdomsObject;", "save", "", "data", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/base/KingdomsObject;Ljava/io/BufferedWriter;)V", "(Lorg/kingdoms/constants/base/KingdomsObject;)V", "hasData", "", "deleteAllData", "close", "core"})
@SourceDebugExtension(value={"SMAP\nSingularFlatFileDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingularFlatFileDatabase.kt\norg/kingdoms/data/database/flatfile/SingularFlatFileDatabase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public abstract class SingularFlatFileDatabase<T extends KingdomsObject>
implements SingularKingdomsDatabase<T> {
    @NotNull
    private final Path file;
    @NotNull
    private final SingularDataHandler<T> dataHandler;

    public SingularFlatFileDatabase(@NotNull Path file, @NotNull SingularDataHandler<T> dataHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        this.file = file;
        this.dataHandler = dataHandler;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    public final SingularDataHandler<T> getDataHandler() {
        return this.dataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final T load() {
        if (!Files.exists(this.file, new LinkOption[0])) {
            return null;
        }
        Closeable closeable = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)reader);
            T t = this.load(reader);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public abstract T load(@NotNull BufferedReader var1);

    public abstract void save(@NotNull T var1, @NotNull BufferedWriter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            Closeable closeable = FSUtil.standardWriter(this.file);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)writer);
                this.save(data, writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final boolean hasData() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    @Override
    public final void deleteAllData() {
        Files.delete(this.file);
    }

    @Override
    public final void close() {
    }
}

