/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.compressor;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.kingdoms.data.compressor.CompressableData;
import org.kingdoms.data.compressor.DataCompressor;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.reflection.Reflect;

public final class ReflectedObjectCompressor<T>
implements CompressableData<T> {
    private final Class<T> clazz;
    private final List<FieldDescription<?>> fields = new ArrayList();

    private ReflectedObjectCompressor(Class<T> clazz) {
        this.clazz = clazz;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Field field : Reflect.getFields(clazz)) {
            int mods = field.getModifiers();
            if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
            field.setAccessible(true);
            try {
                CompressableData<?> fieldCompressor = DataCompressor.REGISTRY.getCompressor(field.getType());
                this.fields.add(new FieldDescription(lookup.unreflectGetter(field), fieldCompressor));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> ReflectedObjectCompressor<T> of(Class<T> clazz) {
        return new ReflectedObjectCompressor<T>(clazz);
    }

    @Override
    public void compress(DataCompressor compressor, T instance) {
        if (instance.getClass() != this.clazz) {
            throw new IllegalArgumentException();
        }
        for (FieldDescription<?> field : this.fields) {
            try {
                Object data = ((FieldDescription)field).handle.invokeExact(instance);
                ((FieldDescription)field).compressor.compress(compressor, Fn.cast(data));
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while compressing reflected object " + instance + " field " + ((FieldDescription)field).handle, e);
            }
        }
    }

    private static final class FieldDescription<T> {
        private final MethodHandle handle;
        private final CompressableData<T> compressor;

        private FieldDescription(MethodHandle handle2, CompressableData<T> compressor) {
            this.handle = handle2;
            this.compressor = compressor;
        }
    }
}

