/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.compressor;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import org.kingdoms.data.compressor.CompressableData;
import org.kingdoms.data.compressor.DataCompressor;
import org.kingdoms.data.compressor.ReflectedObjectCompressor;
import org.kingdoms.utils.HierarchalClassMap;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.math.Avg;

public final class DataCompressRegistry
implements CompressableData<Object> {
    private final HierarchalClassMap<CompressableData<?>> registry = new HierarchalClassMap();
    private final Map<Class<?>, Avg> averageSize = new IdentityHashMap();

    public void registerDefaults() {
        this.register(Byte.TYPE, DataCompressor::compressByte);
        this.register(Boolean.TYPE, DataCompressor::compress);
        this.register(Character.TYPE, DataCompressor::compress);
        this.register(Short.TYPE, DataCompressor::compress);
        this.register(Integer.TYPE, DataCompressor::compress);
        this.register(Long.TYPE, DataCompressor::compress);
        this.register(Float.TYPE, DataCompressor::compress);
        this.register(Double.TYPE, DataCompressor::compress);
        this.register(byte[].class, DataCompressor::compress);
        this.register(ByteBuffer.class, DataCompressor::compress);
        this.register(String.class, DataCompressor::compress);
        this.register(UUID.class, DataCompressor::compress);
        this.register(Color.class, DataCompressor::compress);
        this.register(Enum.class, DataCompressor::compress);
        this.register(Map.class, DataCompressor::compress);
        this.register(Collection.class, DataCompressor::compress);
    }

    public void registerSize(Class<?> clazz, int size) {
        this.averageSize.compute(clazz, (k, v) -> v == null ? new Avg(size, 1L) : v.plus(size));
    }

    public int getAvgSize(Class<?> clazz, int defaultSize) {
        return (int)this.averageSize.getOrDefault(clazz, new Avg(defaultSize, 1L)).getAverage();
    }

    public <T> void register(Class<T> clazz, CompressableData<T> handler) {
        this.registry.put(clazz, handler);
    }

    public <D> CompressableData<D> getCompressor(Class<D> clazz) {
        return this.registry.get(clazz);
    }

    @Override
    public void compress(DataCompressor compressor, Object object) {
        Class<?> clazz;
        CompressableData<?> fn;
        if (object == null) {
            compressor.compressNull();
        }
        if ((fn = this.registry.get(clazz = object.getClass())) == null) {
            ReflectedObjectCompressor<?> generatedComporessor = ReflectedObjectCompressor.of(clazz);
            this.registry.put(clazz, (CompressableData<?>)generatedComporessor);
            fn = generatedComporessor;
        }
        fn.compress(compressor, Fn.cast(object));
    }
}

