/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.centers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.data.history.DataStructureHistory;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class KingdomsStartup {
    private static final List<Consumer<Kingdoms>> ON_LOAD = new ArrayList<Consumer<Kingdoms>>(10);
    private static final AtomicBoolean READY = new AtomicBoolean();

    public static void whenReady(Consumer<Kingdoms> runnable) {
        Objects.requireNonNull(runnable, "Load consumer cannot be null");
        if (READY.get()) {
            runnable.accept(Kingdoms.get());
        } else {
            ON_LOAD.add(runnable);
        }
    }

    public static boolean isReady() {
        return READY.get();
    }

    @ApiStatus.Internal
    public static void init(Kingdoms plugin) {
        KLogger.info("Initializing kingdoms data...");
        plugin.getDataCenter().getGlobals().getOrLoadData();
        DataStructureHistory.convertDatabase();
        if (KingdomsConfig.DATABASE_LOAD_ALL_DATA_ON_STARTUP.getBoolean()) {
            KingdomsStartup.loadNations(plugin);
            KingdomsStartup.loadKingdoms(plugin);
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> KingdomsStartup.onReady(plugin), 20L);
    }

    private static void onReady(Kingdoms plugin) {
        plugin.getPermissionRegistery().lock();
        plugin.getRelationAttributeRegistry().lock();
        plugin.getAuditLogRegistry().lock();
        plugin.getMetadataRegistry().lock();
        READY.set(true);
        for (Consumer<Kingdoms> runnable : ON_LOAD) {
            runnable.accept(plugin);
        }
        if (KingdomsConfig.BACKUPS_ENABLED_ENABLED.getBoolean()) {
            plugin.getBackupManager().autoBackup();
        }
        plugin.getDataCenter().getGlobals().saveAll(true);
    }

    private static void loadNations(Kingdoms plugin) {
        NationManager manager = plugin.getDataCenter().getNationManager();
        MessageHandler.sendConsolePluginMessage("&2Setting up nations data...");
        long start = System.currentTimeMillis();
        int loaded = manager.loadAllData(false).size();
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded + " &2nations. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }

    private static void loadKingdoms(Kingdoms plugin) {
        KingdomManager manager = plugin.getDataCenter().getKingdomManager();
        MessageHandler.sendConsolePluginMessage("&2Setting up kingdoms data...");
        long start = System.currentTimeMillis();
        int loaded = manager.loadAllData(false).size();
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded + " &2kingdoms. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }

    private static void loadLands(Kingdoms plugin) {
        MessageHandler.sendConsolePluginMessage("&2Loading lands data...");
        long start = System.currentTimeMillis();
        Collection<Land> loaded = plugin.getDataCenter().getLandManager().loadAllData(false);
        AsyncBatchLandLoadEvent loadEvent = new AsyncBatchLandLoadEvent(loaded);
        Bukkit.getPluginManager().callEvent((Event)loadEvent);
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded.size() + " &2lands. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }
}

