/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.centers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.database.base.SingularKingdomsDatabase;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.data.handlers.abstraction.SingularDataHandler;
import org.kingdoms.data.managers.BaseDataManager;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.string.StringPadder;
import org.kingdoms.utils.string.Strings;

public abstract class DataCenter
extends BaseDataManager {
    protected final DatabaseType databaseType;
    protected long lastSignalledSave;
    protected final NamespacedMap<DataManager<?>> registry = new NamespacedMap();
    protected boolean loadedInitials = false;
    protected final DelayedRepeatingTask autoSaveTask;

    @ApiStatus.Internal
    public DataCenter(Namespace namespace, DatabaseType databaseType, Duration autoSaveInterval, boolean staticCache, boolean temporary, boolean smartSaving) {
        super(namespace, autoSaveInterval, staticCache, temporary, smartSaving);
        this.databaseType = Objects.requireNonNull(databaseType);
        this.autoSaveTask = autoSaveInterval != null ? Kingdoms.taskScheduler().async().repeating(autoSaveInterval, autoSaveInterval, new AutoSaver()) : null;
    }

    @ApiStatus.Internal
    public boolean hasLoadedInitials() {
        return this.loadedInitials;
    }

    public <T extends DataManager<?>> T register(T dataManager) {
        this.registry.put(dataManager.getNamespace(), dataManager);
        return dataManager;
    }

    @Override
    @ApiStatus.Internal
    public void onDisable() {
        this.getAllDataManagers().forEach(DataManager::onDisable);
    }

    public void saveAll(SaveType saveType) {
        KLogger.debug((DebugNS)KingdomsDebug.SAVE_ALL, () -> "Saving all data... (" + saveType.name() + ')');
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        StringPadder padder = new StringPadder();
        List sortedManagers = this.getAllDataManagers().stream().sorted(Comparator.comparing(x -> x.getNamespace().asNormalizedString())).collect(Collectors.toList());
        for (DataManager manager : sortedManagers) {
            int cachedData = manager.loadedCount();
            long beforeSave = System.currentTimeMillis();
            int totalSaved = 0;
            Throwable error = null;
            try {
                totalSaved = saveType == SaveType.AUTO ? manager.autoSave() : manager.saveAll(manager.isSmartSaving());
            }
            catch (Throwable ex) {
                error = ex;
                errors.add(ex);
            }
            long afterSave = System.currentTimeMillis();
            long took = afterSave - beforeSave;
            padder.pad("\n  &7| &3" + manager.getNamespace().asNormalizedString() + "&8: &9", (error == null ? Integer.valueOf(totalSaved) : "&cFailed") + "&7/&9" + cachedData, " &8(&9" + took + "ms&8)");
        }
        MessageHandler.sendConsolePluginMessage("&2" + saveType.description + " Save&8: " + padder.getPaddedString(""));
        errors.forEach(Throwable::printStackTrace);
        if (saveType == SaveType.SIGNALLED) {
            this.lastSignalledSave = System.currentTimeMillis();
        }
    }

    public NamespacedMap<DataManager<?>> getRegistry() {
        return this.registry;
    }

    public <K, T extends KeyedKingdomsObject<K>> KeyedKingdomsDatabase<K, T> constructDatabase(String name, String table, KeyedDataHandler<K, T> dataHandler) {
        return (KeyedKingdomsDatabase)this.constructDatabase0(name, table, dataHandler);
    }

    public <T extends KingdomsObject> SingularKingdomsDatabase<T> constructDatabase(String name, String table, SingularDataHandler<T> dataHandler) {
        return (SingularKingdomsDatabase)this.constructDatabase0(name, table, dataHandler);
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    protected abstract <T extends KingdomsObject> KingdomsDatabase<T> constructDatabase0(String var1, String var2, DataHandler<T> var3);

    public Collection<DataManager<?>> getAllDataManagers() {
        return this.registry.values();
    }

    public void signalFullSave() {
        Duration lastSave = Duration.ofMillis(this.lastSignalledSave);
        Duration shouldSaveAter = lastSave.plus(Duration.ofSeconds(30L));
        Duration current = Duration.ofMillis(System.currentTimeMillis());
        if (!current.minus(shouldSaveAter).isNegative()) {
            this.saveAll(SaveType.SIGNALLED);
        }
    }

    public long getLastSignalledSave() {
        return this.lastSignalledSave;
    }

    @Override
    public void close() {
        super.close();
        if (this.autoSaveTask != null) {
            this.autoSaveTask.cancel();
        }
        this.getAllDataManagers().forEach(DataManager::close);
    }

    private final class AutoSaver
    implements Runnable {
        private AutoSaver() {
        }

        @Override
        public void run() {
            DataCenter.this.saveAll(SaveType.AUTO);
        }
    }

    public static enum SaveType {
        AUTO,
        SIGNALLED,
        MANUAL;

        protected final String description = Strings.capitalize(this.name());
    }
}

