/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.top;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.kingdoms.constants.top.IndexedTopData;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;

public abstract class ExpressionBasedTopData<K, V>
extends IndexedTopData<K, V> {
    private final MathExpression comparator;
    private final ConditionalExpression filter;
    private final Predicate<V> predicate;
    private final String dataName;
    private final Messenger displayName;
    private final Messenger description;

    public ExpressionBasedTopData(MathExpression comparator, ConditionalExpression filter, String dataName, Messenger displayName, Messenger description) {
        this.comparator = Objects.requireNonNull(comparator);
        this.filter = filter;
        this.predicate = filter == null ? null : v -> ConditionProcessor.process(filter, this.getPlaceholderProvider(v));
        this.dataName = Validate.notEmpty(dataName);
        this.displayName = Objects.requireNonNull(displayName);
        this.description = Objects.requireNonNull(description);
    }

    protected abstract PlaceholderProvider getPlaceholderProvider(V var1);

    public static <TOP extends ExpressionBasedTopData<?, ?>> void parse(ConfigSection section, Creator<TOP> creator, Map<String, TOP> tops) {
        for (String name : section.getKeys()) {
            ConfigSection topType = section.getSection(name);
            MathExpression equation = topType.getMathExpression("equation");
            ConditionalExpression filter = topType.getCondition("filter");
            if (equation == null || equation.isDefault()) {
                KLogger.error("No equation defined for top type: " + name);
                continue;
            }
            String displayNameStr = topType.getString("name");
            if (Strings.isNullOrEmpty((String)displayNameStr)) {
                displayNameStr = name;
            }
            StaticMessenger displayName = new StaticMessenger(MessageCompiler.compile(displayNameStr));
            String descStr = topType.getString("description");
            Messenger description = Strings.isNullOrEmpty((String)descStr) ? KingdomsLang.NONE : new StaticMessenger(MessageCompiler.compile(descStr));
            tops.put(name, creator.create(topType, name, displayName, description, equation, filter));
        }
    }

    public ConditionalExpression getFilter() {
        return this.filter;
    }

    @Nullable
    public Predicate<V> getPredicate() {
        return this.predicate;
    }

    public Messenger getDisplayName() {
        return this.displayName;
    }

    public Messenger getDescription() {
        return this.description;
    }

    public String getDataName() {
        return this.dataName;
    }

    @Override
    public boolean isIncluded(V data) {
        return this.predicate.test(data);
    }

    public double getTopValueOf(V data) {
        return MathUtils.eval(this.comparator, this.getPlaceholderProvider(data));
    }

    @Override
    public int compare(V o1, V o2) {
        double e2;
        double e1 = this.getTopValueOf(o1);
        if (e1 < (e2 = this.getTopValueOf(o2))) {
            return -1;
        }
        if (e1 > e2) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + "name=" + this.dataName + ", displayName=" + this.displayName + ", equation=" + this.comparator.asString(true) + ", filter=" + (this.filter == null ? "null" : this.filter.asString(true)) + ')';
    }

    public static interface Creator<TOP extends ExpressionBasedTopData<?, ?>> {
        public TOP create(ConfigSection var1, String var2, Messenger var3, Messenger var4, MathExpression var5, ConditionalExpression var6);
    }
}

