/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.themes;

import java.awt.Color;
import java.util.List;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.themes.ThemeContainer;
import org.kingdoms.constants.themes.ThemeProvider;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.ColorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/constants/themes/AbstractTheme;", "Lorg/kingdoms/constants/themes/ThemeProvider;", "<init>", "()V", "isThemeAllowed", "", "container", "Lorg/kingdoms/constants/themes/ThemeContainer;", "theme", "Ljava/awt/Color;", "addMessageContextEdits", "", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "", "core"})
public abstract class AbstractTheme
implements ThemeProvider {
    @Override
    public boolean isThemeAllowed(@NotNull ThemeContainer container, @NotNull Color theme) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        String string = this.getNamespace().getConfigOptionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigOptionName(...)");
        String configOptionName = string;
        if (KingdomsConfig.COLOR_RANGE_ENABLED.getManager().withOption("type", configOptionName).getBoolean()) {
            float[] hsb = ColorUtils.getHSB(theme);
            float hue = hsb[0];
            float saturation = hsb[1];
            float brightness = hsb[2];
            if (saturation > 40.0f && brightness > 40.0f) {
                boolean blacklist = KingdomsConfig.COLOR_RANGE_BLACKLIST.getManager().withOption("type", configOptionName).getBoolean();
                ConfigAccessor section = KingdomsConfig.COLOR_RANGE_COLORS.getManager().withOption("type", configOptionName).noDefault().getSection();
                if (section != null) {
                    for (String colors : section.getKeys()) {
                        boolean matches;
                        String[] stringArray = new String[]{colors};
                        List<Integer> list = section.getIntegerList(stringArray);
                        if (list.size() != 2 || blacklist != (matches = hue >= (float)((Number)list.get(0)).intValue() && hue <= (float)((Number)list.get(1)).intValue())) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.raw("color_displayname", this.getDisplayName());
        context.raw("color_description", this.getDescription());
        context.raw("color_type", this.getNamespace().asNormalizedString());
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getNamespace() + ')';
    }
}

