/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.stats;

import java.util.ArrayList;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.stats.AverageStat;
import org.kingdoms.constants.stats.BooleanStat;
import org.kingdoms.constants.stats.GroupedStat;
import org.kingdoms.constants.stats.ListStat;
import org.kingdoms.constants.stats.NumberStat;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.math.Avg;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/constants/stats/StatRegistry;", "", "<init>", "()V", "providers", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/constants/stats/Stat$Provider;", "NS_NUMBER", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "NS_AVERAGE", "NS_BOOL", "NS_GROUP", "NS_LIST", "deserializeStat", "Lorg/kingdoms/constants/stats/Stat;", "valueProvider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serializeStat", "", "stat", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public final class StatRegistry {
    @NotNull
    public static final StatRegistry INSTANCE;
    @JvmField
    @NotNull
    public static final NamespacedMap<Stat.Provider> providers;
    @JvmField
    @NotNull
    public static final Namespace NS_NUMBER;
    @JvmField
    @NotNull
    public static final Namespace NS_AVERAGE;
    @JvmField
    @NotNull
    public static final Namespace NS_BOOL;
    @JvmField
    @NotNull
    public static final Namespace NS_GROUP;
    @JvmField
    @NotNull
    public static final Namespace NS_LIST;

    private StatRegistry() {
    }

    @JvmStatic
    @Nullable
    public static final Stat deserializeStat(@NotNull SectionableDataGetter valueProvider) {
        Intrinsics.checkNotNullParameter((Object)valueProvider, (String)"valueProvider");
        String string = valueProvider.getString("type");
        Intrinsics.checkNotNull((Object)string);
        Namespace namespace = Namespace.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace type = namespace;
        DeserializationContext<DataGetter> deserializer = new DeserializationContext<DataGetter>(valueProvider.get("value"));
        Stat.Provider provider = providers.get(type);
        if (provider == null) {
            KLogger.error("Unknown stat provider: " + type);
            return null;
        }
        Stat stat = provider.construct();
        stat.deserialize(deserializer);
        return stat;
    }

    @JvmStatic
    public static final void serializeStat(@NotNull Stat stat, @NotNull SectionableDataSetter valueProvider) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        Intrinsics.checkNotNullParameter((Object)valueProvider, (String)"valueProvider");
        valueProvider.setString("type", stat.getNamespace().asNormalizedString());
        stat.serialize(new SerializationContext<DataSetter>(valueProvider.get("value")));
    }

    private static final Stat lambda$5$lambda$0() {
        return new NumberStat(0L);
    }

    private static final Stat lambda$5$lambda$1() {
        return new AverageStat(new Avg(0.0, 0L));
    }

    private static final Stat lambda$5$lambda$2() {
        return new BooleanStat(false);
    }

    private static final Stat lambda$5$lambda$3() {
        return new GroupedStat(new Statistics());
    }

    private static final Stat lambda$5$lambda$4() {
        return new ListStat(new ArrayList());
    }

    static {
        NamespacedMap<Stat.Provider> namespacedMap;
        INSTANCE = new StatRegistry();
        providers = new NamespacedMap();
        Namespace namespace = Namespace.kingdoms("NUMBER");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        NS_NUMBER = namespace;
        Namespace namespace2 = Namespace.kingdoms("AVERAGE");
        Intrinsics.checkNotNullExpressionValue((Object)namespace2, (String)"kingdoms(...)");
        NS_AVERAGE = namespace2;
        Namespace namespace3 = Namespace.kingdoms("BOOL");
        Intrinsics.checkNotNullExpressionValue((Object)namespace3, (String)"kingdoms(...)");
        NS_BOOL = namespace3;
        Namespace namespace4 = Namespace.kingdoms("GROUP");
        Intrinsics.checkNotNullExpressionValue((Object)namespace4, (String)"kingdoms(...)");
        NS_GROUP = namespace4;
        Namespace namespace5 = Namespace.kingdoms("LIST");
        Intrinsics.checkNotNullExpressionValue((Object)namespace5, (String)"kingdoms(...)");
        NS_LIST = namespace5;
        NamespacedMap<Stat.Provider> $this$_init__u24lambda_u245 = namespacedMap = providers;
        boolean bl = false;
        $this$_init__u24lambda_u245.put(NS_NUMBER, StatRegistry::lambda$5$lambda$0);
        $this$_init__u24lambda_u245.put(NS_AVERAGE, StatRegistry::lambda$5$lambda$1);
        $this$_init__u24lambda_u245.put(NS_BOOL, StatRegistry::lambda$5$lambda$2);
        $this$_init__u24lambda_u245.put(NS_GROUP, StatRegistry::lambda$5$lambda$3);
        $this$_init__u24lambda_u245.put(NS_LIST, StatRegistry::lambda$5$lambda$4);
    }
}

