/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.stats;

import java.util.List;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.stats.NumberStat;

public final class DefaultStats {

    public static final class KingdomPlayer {
        public static final List<Namespace> KINGDOMS_CREATED = Namespace.path("KINGDOMS_CREATED");
    }

    public static final class Turret {
        public static final List<Namespace> TURRETS_SHOTS = Namespace.path("SHOTS");
        public static final List<Namespace> TURRETS_KILLS = Namespace.path("KILLS");
    }

    public static final class Kingdom {
        public static final List<Namespace> NATION_SINCE = Kingdom.nation("SINCE");
        public static final List<Namespace> TOTAL_KILLS = Kingdom.members("TOTAL_KILLS");
        public static final List<Namespace> TOTAL_DEATHS = Kingdom.members("TOTAL_DEATHS");
        public static final List<Namespace> MEMBERS_TOTAL = Kingdom.members("TOTAL");
        public static final List<Namespace> LANDS_TOTAL = Kingdom.lands("TOTAL");
        public static final List<Namespace> INVASIONS_INVADED = Kingdom.invasion("INVADED");
        public static final List<Namespace> INVASIONS_GOT_INVADED = Kingdom.invasion("GOT_INVADED");
        public static final List<Namespace> INVASIONS_GOT_INVADED_LOST = Kingdom.invasion("GOT_INVADED_LOST");
        public static final List<Namespace> INVASIONS_INVADED_WON = Kingdom.invasion("INVADED_WON");

        private static List<Namespace> nation(String ns) {
            return Namespace.path("NATION", ns);
        }

        private static List<Namespace> invasion(String ns) {
            return Namespace.path("INVASIONS", ns);
        }

        private static List<Namespace> members(String ns) {
            return Namespace.path("MEMBERS", ns);
        }

        private static List<Namespace> lands(String ns) {
            return Namespace.path("LANDS", ns);
        }

        public static void setNationSince(org.kingdoms.constants.group.Kingdom kingdom) {
            kingdom.getStatistics().addOrReplace(NATION_SINCE, new NumberStat(System.currentTimeMillis()));
        }
    }
}

