/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.stats;

import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.stats.AbstractStat;
import org.kingdoms.constants.stats.StatRegistry;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.math.Avg;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/constants/stats/AverageStat;", "Lorg/kingdoms/constants/stats/AbstractStat;", "value", "Lorg/kingdoms/utils/math/Avg;", "<init>", "(Lorg/kingdoms/utils/math/Avg;)V", "getValue", "()Lorg/kingdoms/utils/math/Avg;", "setValue", "getNamespace", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public final class AverageStat
extends AbstractStat {
    @NotNull
    private Avg value;

    public AverageStat(@NotNull Avg value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @Override
    @NotNull
    public Avg getValue() {
        return this.value;
    }

    public void setValue(@NotNull Avg avg) {
        Intrinsics.checkNotNullParameter((Object)avg, (String)"<set-?>");
        this.value = avg;
    }

    @Override
    @NotNull
    public Namespace getNamespace() {
        return StatRegistry.NS_AVERAGE;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        SectionableDataGetter section = context.getDataProvider().asSection();
        this.setValue(new Avg(section.getDouble("sum"), section.getLong("count")));
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        context.getDataProvider().setDouble("sum", this.getValue().getSum());
        context.getDataProvider().setLong("count", this.getValue().getCount());
    }
}

