/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.OrderedSet;

public class Rank
extends KeyedKingdomsObject<String>
implements Comparable<Rank>,
Cloneable {
    private static final RankMap DEFAULT_KINGDOM_RANKS = new RankMap();
    private static final RankMap DEFAULT_NATIONAL_RANKS = new RankMap();
    public static boolean CUSTOM_RANKS;
    private transient @NonNull String node;
    private XMaterial material;
    private String name;
    private String color;
    private String symbol;
    private int priority;
    private int maxClaims;
    private @NonNull Set<KingdomPermission> permissions;

    public Rank(@NonNull String node, String name, String color, String symbol, XMaterial material, int priority, int maxClaims, Set<KingdomPermission> permissions) {
        Validate.isTrue(priority >= 0, "Rank priority must be greater than -1");
        this.node = Objects.requireNonNull(node, "Rank node cannot be null");
        this.name = name;
        this.color = color;
        this.symbol = symbol;
        this.priority = priority;
        this.maxClaims = maxClaims;
        this.material = Objects.requireNonNull(material, "Rank material cannot be null");
        this.permissions = Objects.requireNonNull(permissions, "Rank permissions cannot be null");
    }

    public static RankMap copyDefaults(Group group) {
        return Rank.copyDefaults(group instanceof Nation);
    }

    public static RankMap copyDefaults(boolean national) {
        return (national ? DEFAULT_NATIONAL_RANKS : DEFAULT_KINGDOM_RANKS).clone();
    }

    public static void init() {
        CUSTOM_RANKS = KingdomsConfig.Ranks.CUSTOM_RANKS_ENABLED.getManager().getBoolean();
        Rank.init("kingdom", DEFAULT_KINGDOM_RANKS);
        Rank.init("national", DEFAULT_NATIONAL_RANKS);
    }

    private static void init(String type, RankMap map) {
        map.clear();
        int priority = 0;
        ConfigSection section = KingdomsConfig.RANKS.getConfig().getSection(type + "-ranks");
        Objects.requireNonNull(section, () -> "Cannot find rank section for " + section);
        for (String rank : section.getKeys()) {
            new RankParser(type, rank).parse(priority, map);
            ++priority;
        }
    }

    public static RankMap getDefaultKingdomRanks() {
        return DEFAULT_KINGDOM_RANKS;
    }

    public static @Nullable KingdomPlayer determineNextKing(@NonNull List<KingdomPlayer> members, boolean orKeepIfNone) {
        if (members.isEmpty()) {
            return null;
        }
        members.sort(KingdomPlayer::compareTo);
        KingdomPlayer first = members.get(0);
        if (!first.getRank().isKing()) {
            return first;
        }
        if (members.size() == 1 && first.getRank().isKing()) {
            if (orKeepIfNone) {
                return first;
            }
            return null;
        }
        return members.get(1);
    }

    public static Rank getHighestRank() {
        return DEFAULT_KINGDOM_RANKS.getHighestRank();
    }

    public static @NonNull Rank getLowestRank() {
        return DEFAULT_KINGDOM_RANKS.getLowestRank();
    }

    public Set<KingdomPermission> copyPermissions() {
        return new OrderedSet<KingdomPermission>(this.permissions);
    }

    public boolean hasPermission(KingdomPermission permission) {
        return this.isKing() || this.permissions.contains(permission);
    }

    public @NonNull Rank clone() {
        return new Rank(this.node, this.name, this.color, this.symbol, this.material, this.priority, this.maxClaims, this.copyPermissions());
    }

    @Override
    public int compareTo(@NonNull Rank rank) {
        return Integer.compare(this.priority, rank.priority);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    @Override
    public @NonNull String getKey() {
        return this.node;
    }

    public String toString() {
        return "Rank:{node=" + this.node + ", name=" + this.name + ", priority=" + this.priority + ", color=" + this.color + ", symbol=" + this.symbol + ", maxClaims=" + this.maxClaims + ", material=" + this.material.name() + ", permissions=" + Arrays.toString(this.permissions.toArray()) + '}';
    }

    public String toShortString() {
        return "Rank{node='" + this.node + '\'' + ", name='" + this.name + '\'' + ", priority=" + this.priority + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rank)) {
            return false;
        }
        Rank rank = (Rank)obj;
        return this.node.equals(rank.node);
    }

    public boolean isHigherThan(@NonNull Rank rank) {
        Objects.requireNonNull(rank, "Cannot compare null rank");
        return this.priority < rank.priority;
    }

    public boolean isKing() {
        return this.priority == 0;
    }

    public @NonNull String getNode() {
        return this.node;
    }

    protected void setNode(@NonNull String node) {
        if (node == null || node.isEmpty()) {
            throw new IllegalArgumentException("Rank node cannot be null or empty");
        }
        this.node = node;
    }

    public boolean canBePromoted() {
        return this.priority > 1;
    }

    public @NonNull XMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(XMaterial material) {
        this.material = material;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getColor() {
        return this.color;
    }

    public void setColor(@Nullable String color) {
        this.color = color;
    }

    public @Nullable String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nullable String symbol) {
        this.symbol = symbol;
    }

    public int getMaxClaims() {
        return this.maxClaims;
    }

    public void setMaxClaims(int maxClaims) {
        this.maxClaims = maxClaims;
    }

    public @IntRange(from=0L, to=0x7FFFFFFFL) int getPriority() {
        return this.priority;
    }

    @ApiStatus.Internal
    protected void setPriority(@IntRange(from=0L, to=0x7FFFFFFFL) int priority) {
        Validate.isTrue(priority >= 0, "Rank priority must be greater than -1");
        this.priority = priority;
    }

    public @NonNull Set<KingdomPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(@NonNull Set<KingdomPermission> permissions) {
        this.permissions = Objects.requireNonNull(permissions, "Rank permissions cannot be null");
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.raw("rank_node", this.node).raw("rank_name", this.name).raw("rank_symbol", this.symbol).parse("rank_color", this.color).raw("rank_priority", this.priority);
    }

    private static final class RankParser {
        private final String type;
        private final String rank;

        private RankParser(String type, String rank) {
            this.type = type;
            this.rank = rank;
        }

        private KeyedConfigAccessor getOption(KingdomsConfig.Ranks config) {
            return config.getManager().withOption("type", this.type + "-ranks").withOption("rank", this.rank);
        }

        private void parse(int priority, RankMap map) {
            String name = this.getOption(KingdomsConfig.Ranks.NAME).getString();
            String color = this.getOption(KingdomsConfig.Ranks.COLOR).getString();
            String symbol = this.getOption(KingdomsConfig.Ranks.SYMBOL).getString();
            String matStr = this.getOption(KingdomsConfig.Ranks.MATERIAL).getString();
            XMaterial material = Strings.isNullOrEmpty((String)matStr) ? XMaterial.DIRT : XMaterial.matchXMaterial((String)matStr).orElse(XMaterial.DIRT);
            int maxClaims = this.getOption(KingdomsConfig.Ranks.MAX_CLAIMS).getInt();
            OrderedSet<KingdomPermission> permissions = new OrderedSet<KingdomPermission>(0);
            for (String permission : this.getOption(KingdomsConfig.Ranks.PERMISSIONS).getStringList()) {
                KingdomPermission perm = (KingdomPermission)((Object)Kingdoms.get().getPermissionRegistery().getRegistered(Namespace.fromString(permission)));
                if (perm == null) {
                    MessageHandler.sendConsolePluginMessage("&cCould not find permission for default rank &e" + this.rank + " (" + name + ")&8: &e" + permission + " (" + perm + ')');
                    continue;
                }
                permissions.add(perm);
            }
            Objects.requireNonNull(color, () -> "Default rank color is not found for " + this.rank);
            Objects.requireNonNull(symbol, () -> "Default rank symbol is not found for " + this.rank);
            map.add(new Rank(this.rank.toLowerCase(Locale.ENGLISH), name, color, symbol, material, priority, maxClaims, permissions));
        }
    }
}

