/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.DefaultedMessageObject;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.MessengerMessageObject;
import org.kingdoms.locale.compiler.container.MessageContainer;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionBranch;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.string.QuantumString;

public class KingdomsChatChannel {
    private static final Map<QuantumString, KingdomsChatChannel> CHANNELS = new HashMap<QuantumString, KingdomsChatChannel>(5);
    private final String id;
    private final String dataId;
    private final MessageObject color;
    private final ConditionalExpression recipientCondition;
    private final ConditionChain<Messenger> useConditions;
    private final MessageContainer formats;
    private final List<Pair<ConditionalExpression, String>> adminFormats;
    public static final String GLOBAL_DATA_ID = "GLOBAL";

    public static void registerChannels() {
        CHANNELS.clear();
        ConfigSection section = KingdomsConfig.Chat.CHANNELS.getManager().getSection().getSection();
        for (Map.Entry<String, ConfigSection> channel : section.getSections().entrySet()) {
            String id = channel.getKey();
            KeyedConfigAccessor channelSection = KingdomsConfig.Chat.CHANNELS.getManager().withProperty(id).applyProperties();
            MessageObject color = MessageCompiler.compile(KingdomsConfig.Chat.CHANNELS_COLOR.getManager().withOption("channel", id).getString());
            String recCond = KingdomsConfig.Chat.CHANNELS_RECIPIENTS_CONDITION.getManager().withOption("channel", id).getString();
            ConditionalCompiler.LogicalOperand recipientCondition = recCond == null ? null : ConditionalCompiler.compile(recCond).evaluate();
            KeyedYamlConfigAccessor useConditionsOption = KingdomsConfig.Chat.CHANNELS_USE_CONDITIONS.getManager().withOption("channel", id);
            YamlConfigAccessor sectionCond = useConditionsOption.getSection();
            ConditionChain<Messenger> useConditions = null;
            if (sectionCond != null) {
                useConditions = ConditionProcessor.mapConditions(sectionCond.getSection(), true);
            } else {
                String singleCondition = useConditionsOption.getString();
                if (singleCondition != null) {
                    useConditions = new ConditionChain<LanguageEntryMessenger>(new ConditionBranch<LanguageEntryMessenger>(ConditionalCompiler.compile(singleCondition).evaluate(), new LanguageEntryMessenger("channels", "default-permission-fail")));
                }
            }
            KingdomsChatChannel chan = new KingdomsChatChannel(id, color, recipientCondition, useConditions, MessageContainer.parse(channelSection.withProperty("formats")), MessageContainer.parseRaw(channelSection.clearExtras().withProperty("admin-formats")));
            CHANNELS.put(QuantumString.of(chan.dataId), chan);
        }
    }

    public static KingdomsChatChannel getChannelUserFriendly(String name, MessagePlaceholderProvider settings) {
        name = name.toLowerCase();
        for (KingdomsChatChannel chan : CHANNELS.values()) {
            if (name.equals(chan.id.toLowerCase(Locale.ENGLISH))) {
                return chan;
            }
            MessageObjectBuilder messageObjectBuilder1 = chan.getName();
            if (name.equals(messageObjectBuilder1.buildPlain(settings).toLowerCase())) {
                return chan;
            }
            MessageObjectBuilder messageObjectBuilder = chan.getShortName();
            if (!name.equals(messageObjectBuilder.buildPlain(settings).toLowerCase())) continue;
            return chan;
        }
        return null;
    }

    public static Map<QuantumString, KingdomsChatChannel> getChannels() {
        return CHANNELS;
    }

    public KingdomsChatChannel(String id, MessageObject color, ConditionalExpression recipientCondition, ConditionChain<Messenger> useConditions, MessageContainer formats, List<Pair<ConditionalExpression, String>> adminFormats) {
        this.id = id;
        this.dataId = id.toUpperCase(Locale.ENGLISH);
        this.color = color;
        this.recipientCondition = recipientCondition;
        this.useConditions = useConditions;
        this.formats = formats;
        this.adminFormats = adminFormats;
    }

    public static KingdomsChatChannel fromId(String id) {
        return CHANNELS.get(QuantumString.of(id));
    }

    public static KingdomsChatChannel getGlobalChannel() {
        return KingdomsChatChannel.fromId(GLOBAL_DATA_ID);
    }

    public List<Pair<ConditionalExpression, String>> getAdminFormat() {
        return this.adminFormats;
    }

    private MessageObjectBuilder getMessageObject(String entry, String defaultVal) {
        return new DefaultedMessageObject(new LanguageEntryWithContext("channels", this.id, entry), new MessengerMessageObject(new StaticMessenger(defaultVal)));
    }

    public MessageObjectBuilder getName() {
        return this.getMessageObject("name", this.id);
    }

    public MessageObjectBuilder getShortName() {
        return this.getMessageObject("short-name", String.valueOf(Character.toUpperCase(this.id.charAt(0))));
    }

    public MessageContainer getFormats() {
        return this.formats;
    }

    public MessageObject getColor() {
        return this.color;
    }

    public String getBypassPrefix() {
        return this.getOption(KingdomsConfig.Chat.CHANNELS_RANGED_BYPASS_PREFIX).getString();
    }

    public ConditionalExpression getRecipientCondition() {
        return this.recipientCondition;
    }

    public ConditionChain<Messenger> getUseConditions() {
        return this.useConditions;
    }

    public Messenger canUse(Player player) {
        if (this.useConditions == null) {
            return null;
        }
        return this.useConditions.evaluate(new PlaceholderContextBuilder().withContext(player), false);
    }

    public boolean isGlobal() {
        return this.dataId.equals(GLOBAL_DATA_ID);
    }

    private KeyedYamlConfigAccessor getOption(KingdomsConfig.Chat cfg) {
        return cfg.getManager().withOption("channel", this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String toString() {
        return "KingdomsChatChannel{" + this.id + '}';
    }
}

