/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class NamespacedRegistry<V extends Namespaced> {
    protected final Map<Namespace, V> registry;

    public NamespacedRegistry() {
        this.registry = NonNullMap.of(new HashMap());
    }

    public NamespacedRegistry(Map<Namespace, V> registry) {
        this.registry = registry;
    }

    public static <V extends Namespaced> NamespacedRegistry<V> ordered() {
        return new NamespacedRegistry(NonNullMap.of(new LinkedHashMap()));
    }

    public void register(@NonNull V value) {
        this.register(value, false);
    }

    private void register(@NonNull V value, boolean replace) {
        Namespace namespace = value.getNamespace();
        Objects.requireNonNull(namespace, "Cannot register object with null namespace");
        Objects.requireNonNull(value, "Cannot register null object");
        if (replace) {
            this.registry.put(namespace, value);
        } else {
            Namespaced prev = (Namespaced)this.registry.putIfAbsent(namespace, value);
            if (prev != null) {
                throw new IllegalArgumentException(namespace + " was already registered");
            }
        }
    }

    public void replace(V value) {
        this.register(value, true);
    }

    public V getRegistered(@NonNull Namespace namespace) {
        return (V)((Namespaced)this.registry.get(namespace));
    }

    public V getRegistered(@NonNull V namespaced) {
        return (V)((Namespaced)this.registry.get(namespaced.getNamespace()));
    }

    public boolean isRegisetered(@NonNull V namespaced) {
        return this.registry.containsKey(namespaced.getNamespace());
    }

    public boolean isRegisetered(@NonNull Namespace namespace) {
        return this.registry.containsKey(namespace);
    }

    public @NonNull @Unmodifiable Map<Namespace, V> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }
}

