/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.mails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.GroupResolver;
import org.kingdoms.constants.mails.CachedMail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerMail;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;

public class Mail
extends KeyedKingdomsObject<UUID> {
    protected transient UUID id;
    private @NonNull UUID fromGroup;
    private @NonNull UUID sender;
    private @NonNull List<String> message;
    private @NonNull String subject;
    private @Nullable UUID inReplyTo;
    protected @NonNull Map<UUID, MailRecipientType> recipients;
    protected long time;

    public Mail(UUID id, @NonNull UUID from, @NonNull UUID sender, @NonNull String subject, @NonNull Map<UUID, MailRecipientType> recipients, @NonNull List<String> message, @Nullable UUID inReplyTo, boolean loadedFromDatabase) {
        this.id = Objects.requireNonNull(id);
        this.recipients = Objects.requireNonNull(recipients, "Recipients cannot be null");
        this.time = System.currentTimeMillis();
        this.sender = sender;
        this.fromGroup = Objects.requireNonNull(from, "The sender UUID cannot be null");
        this.subject = Objects.requireNonNull(subject, "Subject cannot be null");
        this.message = Objects.requireNonNull(message, "Message cannot be null");
        this.inReplyTo = inReplyTo;
        if (!loadedFromDatabase) {
            KingdomsDataCenter.get().getMTG().loadAndSave(this);
        }
    }

    public static @Nullable Mail getMail(@NonNull UUID id) {
        Objects.requireNonNull(id, "Mail ID cannot be null");
        return (Mail)KingdomsDataCenter.get().getMTG().getOrLoadData(id);
    }

    public CachedMail toCached(GroupResolver resolver) {
        HashMap<Group, MailRecipientType> recipients = new HashMap<Group, MailRecipientType>(this.recipients.size());
        for (Map.Entry<UUID, MailRecipientType> recipient : this.recipients.entrySet()) {
            recipients.put(resolver.getGroup(recipient.getKey()), recipient.getValue());
        }
        return new CachedMail(this.id, resolver.getGroup(this.fromGroup), this.getPlayerSender(), this.message, this.time, this.subject, recipients, this.getRepliedMail());
    }

    public @NonNull UUID getFromGroup() {
        return this.fromGroup;
    }

    public @NonNull UUID getSender() {
        return this.sender;
    }

    public OfflinePlayer getPlayerSender() {
        return Bukkit.getOfflinePlayer((UUID)this.sender);
    }

    public Mail getRepliedMail() {
        return this.inReplyTo == null ? null : Mail.getMail(this.inReplyTo);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Mail)) {
            return false;
        }
        Mail mail = (Mail)obj;
        return this.id.equals(mail.id);
    }

    public @Nullable UUID getInReplyTo() {
        return this.inReplyTo;
    }

    public @NonNull String getSubject() {
        return this.subject;
    }

    public @NonNull List<String> getMessage() {
        return Collections.unmodifiableList(this.message);
    }

    @Override
    public @NonNull UUID getKey() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public @NonNull @Unmodifiable Map<UUID, MailRecipientType> getRecipients() {
        return Collections.unmodifiableMap(this.recipients);
    }

    public @NonNull List<UUID> getRecipientsOfType(MailRecipientType type) {
        ArrayList<UUID> ids = new ArrayList<UUID>(type == MailRecipientType.PRIMARY ? 1 : 5);
        for (Map.Entry<UUID, MailRecipientType> recipient : this.recipients.entrySet()) {
            if (recipient.getValue() != type) continue;
            ids.add(recipient.getKey());
        }
        return ids;
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    public String toString() {
        return "Mail{id=" + this.id + ", fromGroup=" + this.fromGroup + ", sender=" + this.sender + ", message=" + this.message + ", subject='" + this.subject + '\'' + ", inReplyTo=" + this.inReplyTo + ", recipients=" + this.recipients + ", time=" + this.time + '}';
    }

    protected DataHandler<Mail> getDataHandler() {
        return DataHandlerMail.INSTANCE;
    }
}

