/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.libs.xseries.XEntityType;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.versionsupport.VersionSupport;

public abstract class TurretTypeRanged
extends TurretType {
    public TurretTypeRanged(String name, boolean enemies, boolean friends) {
        super(name, enemies, friends);
    }

    public static boolean rayTrace(RangedTurret turret, Kingdom kingdom, LivingEntity target, ShootingCalculations calc) {
        Location from = calc.from;
        Vector direction = calc.direction;
        XEntityType type = turret.getProjectile();
        double raySize = type == null ? 0.1 : 0.5;
        double distance = calc.distance;
        if (type != null) {
            from = from.add(direction.clone().multiply(0.7));
        }
        if (distance <= 1.5) {
            return true;
        }
        RayTraceResult result = from.getWorld().rayTrace(from, direction, turret.getRange(kingdom), FluidCollisionMode.NEVER, true, raySize, entity2 -> entity2.getEntityId() == target.getEntityId());
        if (result == null) {
            return true;
        }
        return result.getHitBlock() == null;
    }

    @Override
    public RangedTurret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new RangedTurret(builder.getStyle(), builder.getLocation());
    }

    public static ShootingCalculations calcShot(Location origin, LivingEntity target) {
        Location entityHitPoint = VersionSupport.SUPPORTS_Entity_getHeight ? target.getLocation().clone().add(0.0, target.getHeight() / 1.7, 0.0) : target.getEyeLocation();
        return TurretTypeRanged.calcShot(origin, entityHitPoint);
    }

    private static ShootingCalculations calcShot(Location origin, Location target) {
        Vector to = target.toVector();
        origin = origin.clone().add(0.5, 0.0, 0.5);
        Vector direction = to.subtract(origin.toVector()).normalize();
        Location from = origin.add(direction.clone().multiply(0.7));
        double distance = LocationUtils.distanceSquared(from, target);
        return new ShootingCalculations(from, direction, distance);
    }

    public static final class ShootingCalculations {
        public final Location from;
        public final Vector direction;
        public final double distance;

        public ShootingCalculations(Location from, Vector direction, double distance) {
            this.from = from;
            this.direction = direction;
            this.distance = distance;
        }
    }
}

