/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.HealingTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.xseries.XAttribute;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.iterator.Iterables;

public class TurretTypeHealing
extends TurretTypeRanged {
    public TurretTypeHealing() {
        super("healing", false, true);
    }

    @Override
    public boolean tryActivate(TurretActivateEvent event) {
        MathExpression repairArmor;
        int repairCount;
        LivingEntity target = event.getTarget();
        double maxHp = target.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).getValue();
        KLogger.debug((DebugNS)KingdomsDebug.TURRET, () -> "Healing turret HP detection: max=" + maxHp + ", hp=" + target.getHealth());
        if (target.getHealth() >= maxHp) {
            return false;
        }
        Turret turret = event.getTurret();
        double amount = turret.getDamage(event.getKingdom());
        EntityRegainHealthEvent regainEvent = new EntityRegainHealthEvent((Entity)target, amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
        Bukkit.getPluginManager().callEvent((Event)regainEvent);
        if (regainEvent.isCancelled()) {
            return false;
        }
        amount = Math.min(target.getHealth() + regainEvent.getAmount(), maxHp);
        target.setHealth(amount);
        if (target instanceof Player && (repairCount = (int)MathUtils.eval(repairArmor = ((TurretStyle)turret.getStyle()).getOption("repair-armor").getMathExpression(), turret.getPlaceholderContext(event.getKingdom(), turret.getLevel()))) > 0) {
            Iterables.chooseRandom(Iterables.ofIterator(((Player)target).getInventory().getArmorContents()), armor -> {
                Damageable damageable;
                if (armor == null || armor.getType() == Material.AIR) {
                    return false;
                }
                ItemMeta meta = armor.getItemMeta();
                if (meta instanceof Damageable && !(damageable = (Damageable)meta).hasDamage()) {
                    damageable.setDamage(Math.max(0, damageable.getDamage() - repairCount));
                    return true;
                }
                return false;
            });
        }
        ParticleDisplay display = turret.getParticle();
        Particles.line((Location)event.getOrigin().clone().add(0.5, 0.0, 0.5), (Location)target.getEyeLocation().add(0.0, -0.25, 0.0), (double)0.2, (ParticleDisplay)display);
        target.addPotionEffects(turret.getHitEffects());
        return true;
    }

    @Override
    public HealingTurret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new HealingTurret(builder.getStyle(), builder.getLocation());
    }
}

