/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.turrets.SoldierManager;
import org.kingdoms.managers.entity.KingdomEntityBuilder;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomTurretEntity;

public class SoldierTurret
extends RangedTurret {
    public SoldierTurret(TurretStyle type, SimpleLocation location) {
        super(type, location);
    }

    @Override
    public void activate(LivingEntity target, Kingdom kingdom) {
        super.activate(target, kingdom);
        this.spawnSoldiers(target, kingdom, this.level);
    }

    @Override
    public boolean skipTarget(LivingEntity target) {
        return super.skipTarget(target) || SoldierManager.getSoldiers().containsKey(target);
    }

    public List<LivingEntity> spawnSoldiers(LivingEntity target, Kingdom kingdom, int lvl) {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("soldiers").getSection();
        if (section == null) {
            return null;
        }
        int closest = KingdomsConfig.getClosestLevelSection(section, lvl);
        section = section.gotoSection(String.valueOf(closest));
        ArrayList<LivingEntity> soldiers = new ArrayList<LivingEntity>(10);
        Location location = target.getLocation();
        if (!kingdom.isClaimed(this.origin.toSimpleChunkLocation())) {
            return null;
        }
        for (String soldierKey : section.getKeys()) {
            ConfigAccessor soldierSection = section.gotoSection(soldierKey);
            MessagePlaceholderProvider context = new MessagePlaceholderProvider().withContext(kingdom);
            int total = Math.max(0, soldierSection.getInt("amount"));
            for (int i = 0; i < total; ++i) {
                LivingEntity soldier = new KingdomEntityBuilder().location(location).settings(soldierSection.getSection()).context(context).forceLevel(lvl).entityType(kingdom.getName() + "'s soldier").registrar(entity2 -> new KingdomTurretEntity((Entity)entity2, this, target)).spawn();
                if (!(soldier instanceof Monster)) continue;
                Monster monster = (Monster)soldier;
                soldiers.add((LivingEntity)monster);
                monster.setTarget(target);
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            Pair<BukkitTask, List<LivingEntity>> guards = SoldierManager.getSoldiers().remove(target);
            if (guards == null) {
                return;
            }
            ParticleDisplay display = ParticleDisplay.of((XParticle)XParticle.WITCH);
            for (LivingEntity guard : guards.getValue()) {
                if (!guard.isValid()) continue;
                display.spawn(guard.getLocation());
                guard.setHealth(0.0);
                KingdomEntityRegistry.remove(guard);
            }
        }, 1200L);
        SoldierManager.getSoldiers().put(target, Pair.of(task, soldiers));
        return soldiers;
    }
}

